package com.kdgcsoft.jt.xzzf.system.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.frame.vo.ComboboxVo;
import com.kdgcsoft.jt.xzzf.system.entity.SysDic;

import java.util.List;

/**
* @Description: 字典查询接口
* @Author: zd
* @Date: 2019/12/20
*/
public interface SysDicService {

    /**
     * 新增信息
     *
     * @param sysDic
     * @return
     */
    Integer insert(SysDic sysDic);

    /**
     * 修改信息
     *
     * @param sysDic
     * @return
     */
    Integer updateById(SysDic sysDic);


    /**
     * 根据ID获取信息
     *
     * @param id
     * @return
     */
    SysDic getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sysDic
     * @return
     */
    Page<SysDic> page(long current, long size, SysDic sysDic);

    /**
     * 根据字典编码、字典值，查询字典文本
     * @param dictCode
     * @param dictValue
     * @return
     */
    String getDictText(String dictCode, String dictValue);

    /**
     * 根据字典编码查询字典并排序
     * @param dictCode
     * @return
     */
    List<ComboboxVo> getListByCode(String dictCode);

    /**
     * 新增字典值
     * @param sysDic
     * @return
     */
    Integer addDicValue(SysDic sysDic);

    /**
     * 根据id删除字典值
     * @param ids
     * @return
     */
    Integer deleteByDicId(String ids);
}
