package com.kdgcsoft.jt.xzzf.system.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.system.entity.SysCode;
import com.kdgcsoft.jt.xzzf.system.entity.SysCodeType;

import java.util.List;

/**
 * <p>
 * 编码类别 服务类
 * </p>
 *
 * @author mapp
 * @since 2019-12-10
 */
public interface SysCodeTypeService {

    /**
     * 新增编码类别信息
     *
     * @param sysCodeType
     * @return
     */
    Integer insert(SysCodeType sysCodeType);

    /**
     * 修改编码类别信息
     *
     * @param sysCodeType
     * @return
     */
    Integer updateById(SysCodeType sysCodeType);

    /**
     * 根据ID删除编码类别信息
     *
     * @param id　编码类别ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取编码类别信息
     *
     * @param id
     * @return
     */
    SysCodeType getById(String id);


    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sysCodeType
     * @return
     */
    Page<SysCodeType> page(long current, long size, SysCodeType sysCodeType);
}

