package com.kdgcsoft.jt.xzzf.system.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.system.entity.SysCode;

import java.util.List;

/**
 * <p>
 * 系统编码表 服务类
 * </p>
 *
 * @author mapp
 * @since 2019-12-10
 */
public interface SysCodeService {

    /**
     * 新增系统编码表信息
     *
     * @param sysCode
     * @return
     */
    Integer insert(SysCode sysCode);

    /**
     * 修改系统编码表信息
     *
     * @param sysCode
     * @return
     */
    Integer updateById(SysCode sysCode);

    /**
     * 根据ID删除系统编码表信息
     *
     * @param id　系统编码表ID
     * @return
     */
    boolean deleteById(String id);

    /**
     * 根据ID获取系统编码表信息
     *
     * @param id
     * @return
     */
    SysCode getById(String id);

    /**
     * 分页查询
     *
     * @param current 当前页
     * @param size 每页显示条数
     * @param sysCode
     * @return
     */
    Page<SysCode> page(long current, long size, SysCode sysCode);

    /**
     * 根据编码类别ID 或者 编码类别代码 获取 编码
     *
     * @param codeTypeId 编码类别ID
     * @param codeTableCode 编码类别代码物理名
     * @return
     */
    List<SysCode> getCodeByCodeType(String codeTypeId, String codeTableCode);


}

