package com.kdgcsoft.jt.xzzf.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.kdgcsoft.jt.xzzf.system.entity.SysUserRole;
import org.apache.ibatis.annotations.Param;

/****
 * @className SysUserRoleMapper
 * @author chris
 * @description 用户角色持久层接口类接口
 * @version 1.0
 * @date 2019-12-27 13:30
 */
public interface SysUserRoleMapper extends BaseMapper<SysUserRole> {

    /******
     * 删除用户角色关联信息
     * @param userId 用户主键Id
     */
    public void deleteUserRoleRelByUserId(@Param("userId") String userId);

    /******
     * 查询角色关联用户总数
     * @param roleId 角色主键Id
     * @return
     */
    public Integer queryUserRoleRelCountByRoleId(@Param("roleId") String roleId);
}
