package com.kdgcsoft.jt.xzzf.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.kdgcsoft.jt.xzzf.system.entity.SysRoleMenu;
import org.apache.ibatis.annotations.Param;

/****
 * @className SysRoleMenuMapper
 * @author chris
 * @description 角色菜单持久层接口接口
 * @version 1.0
 * @date 2019-12-27 11:39
 */
public interface SysRoleMenuMapper extends BaseMapper<SysRoleMenu> {

    /*******
     * 获取菜单关联角色总数
     * @param menuId 菜单主键Id
     * @return
     */
    public Integer getRoleMenuRelCountByMenuId(@Param("menuId") String menuId);

    /*******
     * 获取角色关联菜单总数
     * @param roleId 角色主键Id
     * @return
     */
    public Integer getRoleMenuRelCountByRoleId(@Param("roleId") String roleId);

    /******
     * 删除角色菜单关联关系
     * @param roleId 角色主键Id
     */
    public void deleteRoleMenuRelByRoleId(@Param("roleId") String roleId);
}
