package com.kdgcsoft.jt.xzzf.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.kdgcsoft.jt.xzzf.system.entity.SysRole;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * <p>
 * 角色 Mapper 接口
 * </p>
 *
 * @author mapp
 * @since 2019-12-06
 */
public interface SysRoleMapper extends BaseMapper<SysRole> {


    /**
     * 查询用户角色
     *
     * @param userId
     * @return
     */
    @Select("SELECT T1.* FROM SYS_ROLE T1 , SYS_USER_ROLE T2 WHERE T1.ROLE_ID = T2.ROLE_ID AND T2.USER_ID = #{userId}")
    List<SysRole> queryUserRoleRelByUserId(@Param("userId") String userId);

    /******
     * 获取角色总数
     * @param subSysId 子系统Id
     * @return
     */
    public Integer getRoleCountBySubSysId(@Param("subSysId") String subSysId);
//
//
//    /**
//     * 保存用户角色
//     *
//     * @param userId
//     * @param roleId
//     * @return
//     */
//    @Insert("INSERT INTO SYS_USER_ROLE (USER_ID, ROLE_ID) VALUES (#{userId}, #{roleId})")
//    int saveUserRole(@Param("userId") String userId, @Param("roleId") String roleId);
//
//    /**
//     * 删除用户角色
//     *
//     * @param userId
//     * @return
//     */
//    @Delete("DELETE FROM SYS_USER_ROLE WHERE USER_ID = #{userId}")
//    int deleteUserRole(@Param("userId") String userId);
}
