package com.kdgcsoft.jt.xzzf.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.kdgcsoft.jt.xzzf.system.entity.SysMenu;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 菜单 Mapper 接口
 * </p>
 *
 * @author mapp
 * @since 2019-12-03
 */
public interface SysMenuMapper extends BaseMapper<SysMenu> {

    /*****
     * 查询角色菜单信息
     * @param roleId
     * @return
     */
    public List<SysMenu> queryRoleMenuByRoleId(@Param("roleId") String roleId);

    /*****
     * 查询用户菜单信息
     * @param userId
     * @return
     */
    public List<SysMenu> queryUserMenuByUserId(@Param("userId") String userId);

    /******
     * 获取菜单总数
     * @param subSysId 子系统主键Id
     * @return
     */
    public Integer getMenuCountBySubSysId(@Param("subSysId") String subSysId);

//
//
//    /**
//     * 保存角色菜单信息
//     *
//     * @param roleId
//     * @param menuId
//     * @return
//     */
//    int saveRoleMenu(@Param("roleId") String roleId, @Param("menuId") String menuId);
//
//    /**
//     * 删除角色菜单信息
//     *
//     * @param roleId
//     * @return
//     */
//    int deleteRoleMenu(@Param("roleId") String roleId);
}
