package com.kdgcsoft.jt.xzzf.system.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.kdgcsoft.jt.xzzf.frame.vo.ComboboxVo;
import com.kdgcsoft.jt.xzzf.system.entity.SysDic;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author zd
 * @since 2019-12-20
 */
public interface SysDicMapper extends BaseMapper<SysDic> {

    /**
     * 根据字典名称查询个数
     * @param dicName
     * @return
     */
    @Select("select count(1) from SYS_DIC where DELETE_FLAG = '00' and DIC_NAME = #{dicName}")
    Integer countByDicName(@Param("dicName") String dicName);

    @Update("UPDATE SYS_DIC SET DELETE_FLAG = #{deleteFlag} where dic_id = #{dicId}")
    void deleteByDicId(@Param("dicId") String dicId, @Param("deleteFlag") String deleteFlag);

    @Select("select DIC_VALUE as value,DIC_TEXT as text from SYS_DIC where DELETE_FLAG = '00' " +
            "and DIC_CODE = #{dictCode} order by ORDER_NO")
    public List<ComboboxVo> getListByCode(String dictCode);
}
