package com.kdgcsoft.jt.xzzf.system.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;


/**
 * <p>
 * 用户实体
 * </p>
 *
 * @author mapp
 * @since 2019-11-25
 */
@Data
@TableName("SYS_USER")
public class SysUser extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 用户ID
     */
    @TableId
    private String userId;

    /**
     * 用户名
     */
    @NotNull(message = "用户名不能为空")
    private String userName;

    /**
     * 密码
     */
    @JsonIgnore
    transient private String userPwd;

    @TableField(exist = false)
    private String newPwd;

    /**
     * 真实姓名
     */
    private String name;

    /**
     * 机构ID
     */
    private String orgId;

    /**
     * 登录状态
     */
    private String loginStatus;

    /**
     * 密码错误次数
     */
    private Integer pwdWrongNum;

    /**
     * 登录次数
     */
    private Integer loginNum;

    /**
     * 登录IP
     */
    private String loginIp;

    /**
     * 性别
     */
    private String sex;

    /**
     * 电话
     */
    private String tel;

    /**
     * 邮件
     */
    @Email(message = "邮箱格式不正确")
    private String email;

    /**
     * 部门ID
     */
    private String deptId;

    /**
     * 身份证号
     */
    private String idCard;

    /**
     * 用户类型
     */
    private String userType;

    /**
     * 牌子ID
     */
    private String signId;

    /****
     * 是否超级管理员
     */
    private String isSuperAdmin;

    @Override
    public String getId() {
        return userId;
    }

    @Override
    public void setId(String id) {
        this.userId = id;
    }
}
