package com.kdgcsoft.jt.xzzf.system.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className SysSubSystem
 * @author chris
 * @description 子系统实体类
 * @version 1.0
 * @date 2019-12-24 11:03
 */
@Data
@TableName("SYS_SUB_SYSTEM")
public class SysSubSystem extends BaseEntity<String> {
    private static final long serialVersionUID = 1L;

    /*****
     * 子系统表主键ID
     */
    @TableId
    private String systemId;

    /****
     * 子系统名称
     */
    private String name;

    /****
     * 子系统简称
     */
    private String simpleName;

    /****
     * 子系统URL
     */
    private String url;

    /****
     * 子系统图标样式
     */
    private String iconCss;

    /****
     * 子系统类别
     */
    private String systemType;

    /****
     * 子系统状态
     */
    private String enable;

    /****
     * 子系统排序
     */
    private Integer sort;

    /****
     * 备注
     */
    private String remarks;


    @Override
    public String getId() {
        return systemId;
    }

    @Override
    public void setId(String id) {
        this.systemId = id;
    }
}
