package com.kdgcsoft.jt.xzzf.system.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.time.LocalDateTime;

import lombok.Data;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;

/**
 * <p>
 * 角色
 * </p>
 *
 * @author mapp
 * @since 2019-12-06
 */
@Data
@TableName("SYS_ROLE")
public class SysRole extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 角色ID
     */
    @TableId
    private String roleId;

    /**
     * 角色名称
     */
    private String roleName;

    /**
     * 角色编码
     */
    private String roleCode;

    /**
     * 角色级别
     */
    private Integer roleLevel;

    /**
     * 角色类型
     */
    private String roleType;

    /**
     * 所属行业
     */
    private String roleHy;

    /**
     * 备注
     */
    private String remark;

    /**
     * 机构ID
     */
    private String orgId;

    /****
     * 子系统Id
     */
    private String subSysId;

    /**
     * 删除标志
     */
    private String deleteFlag;

    @Override
    public String getId() {
        return roleId;
    }

    @Override
    public void setId(String id) {
        this.roleId = id;
    }


}
