package com.kdgcsoft.jt.xzzf.system.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className SysOrg
 * @author chris
 * @description 组织机构实体类
 * @version 1.0
 * @date 2019-12-20 17:59
 */
@Data
@TableName("SYS_ORG")
public class SysOrg extends BaseEntity<String> {
    public static final String ORG_ROOT_ID = "0";
    private static final long serialVersionUID = 1L;
    /*****
     * 组织机构表主键ID
     */
    @TableId
    private String orgId;

    /****
     * 父级ID
     */
    private String orgPid;

    /****
     * 机构编码
     */
    private String orgCode;

    /****
     * 机构名称
     */
    private String orgName;

    /****
     * 机构简称
     */
    private String orgShortName;

    /****
     * 统一社会信用代码
     */
    private String orgCard;

    /****
     * 机构地址
     */
    private String orgAddr;

    /****
     * 机构网址
     */
    private String orgWeb;

    /****
     * 机构邮编
     */
    private String orgZip;

    /****
     * 联系电话
     */
    private String tel;

    /****
     * 电子邮箱
     */
    private String email;

    /****
     * 排序
     */
    private String sort;

    /****
     * 备注
     */
    private String remarks;

    @Override
    public String getId() {
        return orgId;
    }

    @Override
    public void setId(String id) {
        this.orgId = id;
    }
}
