package com.kdgcsoft.jt.xzzf.system.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 菜单
 * </p>
 *
 * @author mapp
 * @since 2019-12-03
 */
@Data
@TableName("SYS_MENU")
public class SysMenu extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 菜单ID 主键字段
     */
    @TableId
    private String menuId;

    /**
     * 父菜单ID
     */
    private String menuPid;

    /**
     * 菜单名称
     */
    @NotNull(message = "菜单名称不能为空")
    private String menuName;

    /**
     * 菜单编码
     */
    @NotNull(message = "菜单编码不能为空")
    private String menuCode;

    /**
     * 目录
     */
    private String menuPath;

    /**
     * 页面地址
     */
    private String menuRedirect;

    /**
     * 类型 0：菜单  1：按钮
     */
    private String type;

    /**
     * 图标
     */
    private String menuIcon;

    /**
     * 顺序
     */
    private Integer menuOrder;

    /**
     * 状态  0:启用 1禁用
     */
    private String menuState = "0";

    /**
     * 组件
     */
    private String component;

    /**
     *
     */
    private String label;

    /****
     * 子系统Id
     */
    private String subSysId;

    /**
     * 菜单下的按钮
     */
    @TableField(exist = false)
    private List<SysMenu> btns;

    /****
     * 子系统名称
     */
    @TableField(exist = false)
    private String subSysName;

    @Override
    public String getId() {
        return menuId;
    }

    @Override
    public void setId(String id) {
        this.menuId = id;
    }

    public SysMenu() {
        this.btns = new ArrayList<>();
    }
}
