package com.kdgcsoft.jt.xzzf.system.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className SysDept
 * @author chris
 * @description 部门实体类
 * @version 1.0
 * @date 2019-12-23 17:54
 */
@Data
@TableName("SYS_DEPT")
public class SysDept extends BaseEntity<String> {
    public static final String DEPT_ROOT_ID = "0";
    private static final long serialVersionUID = 1L;

    /**
     * 部门ID 主键字段
     */
    @TableId
    private String deptId;

    /****
     * 父级ID
     */
    private String deptPid;

    /*****
     * 组织机构表主键ID
     */
    private String orgId;

    /****
     * 部门编码
     */
    private String deptCode;

    /****
     * 部门名称
     */
    private String deptName;

    /****
     * 部门简称
     */
    private String deptShortName;

    /****
     * 联系电话
     */
    private String tel;

    /****
     * 电子邮箱
     */
    private String email;

    /****
     * 部门类型
     */
    private String deptType;

    /*****
     * 部门负责人
     */
    private String deptManager;

    /****
     * 排序
     */
    private String sort;

    /****
     * 备注
     */
    private String remarks;

    /*****
     * 部门类型对应的文本值
     */
    @TableField(exist = false)
    private String deptTypeText;

    @Override
    public String getId() {
        return deptId;
    }

    @Override
    public void setId(String id) {
        this.deptId = id;
    }
}
