package com.kdgcsoft.jt.xzzf.system.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <p>
 * 编码类别
 * </p>
 *
 * @author mapp
 * @since 2019-12-10
 */
@Data
@TableName("SYS_CODE_TYPE")
public class SysCodeType extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 编码类别ID
     */
    @TableId
    private String codeTypeId;

    /**
     * 编码类别名称
     */
    @NotNull(message = "编码类别名称不能为空")
    private String codeTypeName;

    /**
     * 编码类别代码物理名，唯一标识。
     */
    @NotNull(message = "编码类别代码物理名不能为空")
    private String codeTableCode;

    @Override
    public String getId() {
        return codeTypeId;
    }

    @Override
    public void setId(String id) {
        this.codeTypeId = id;
    }


}
