package com.kdgcsoft.jt.xzzf.system.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

import javax.validation.constraints.NotNull;

/**
 * <p>
 * 系统编码表
 * </p>
 *
 * @author mapp
 * @since 2019-12-10
 */
@Data
@TableName("SYS_CODE")
public class SysCode extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 编码ID
     */
    @TableId
    private String codeId;

    /**
     * 编码类别ID
     */
    private String codeTypeId;

    /**
     * 编码类别代码物理名，类别的唯一标识。
     */
    @NotNull(message = "编码类别代码物理名不能为空")
    private String codeTableCode;

    /**
     * 编码代码，编码的唯一标识。
     */
    @NotNull(message = "编码代码不能为空")
    private String codeNum;

    /**
     * 编码名称
     */
    @NotNull(message = "编码名称不能为空")
    private String codeName;

    /**
     * 编码在类别中的排序
     */
    private Integer codeOrder;

    @Override
    public String getId() {
        return codeId;
    }

    @Override
    public void setId(String id) {
        this.codeId = id;
    }


}
