package com.kdgcsoft.jt.xzzf.system.controller;

import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.system.service.SysUserRoleService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/****
 * @className SysUserRoleController
 * @author chris
 * @description 用户角色控制层
 * @version 1.0
 * @date 2019-12-27 13:33
 */
@RestController
@RequestMapping("/sysUserRole")
public class SysUserRoleController extends BaseController {

    @Resource
    private SysUserRoleService sysUserRoleService;

    /****
     * 保存用户角色信息
     * @param userId 用户主键Id
     * @param roleIds 角色主键Id集合
     * @return
     */
    @RequestMapping("/save")
    public Result saveUserRole(@RequestParam(required = true) String userId,
                               @RequestParam(required = true) String roleIds) {
        this.sysUserRoleService.saveUserRoleRel(userId, roleIds);
        return Result.success("保存成功");
    }

    /****
     * 查询用户角色
     * @param userId
     * @return
     */
    @RequestMapping("/queryUserRole")
    public Result queryUserRole(String userId) {
        return Result.success(this.sysUserRoleService.queryUserRoleRelByUserId(userId));
    }
}
