package com.kdgcsoft.jt.xzzf.system.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.frame.constants.DictConstants;
import com.kdgcsoft.jt.xzzf.frame.constants.SystemConstants;
import com.kdgcsoft.jt.xzzf.frame.util.SysUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysUser;
import com.kdgcsoft.jt.xzzf.system.service.SysDicService;
import com.kdgcsoft.jt.xzzf.system.service.SysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/*****
 * 用户信息
 * @author mapp
 * @date 2019-11-25
 */
@RestController
@RequestMapping("/user")
public class SysUserController extends BaseController {

    @Resource
    private SysUserService sysUserService;

    @Resource
    private SysDicService sysDicService;

    /******
     * 用户信息分页查询
     * @param current 当前页
     * @param size 分页大小
     * @param entity 实体类
     * @return
     */
    @RequestMapping("/page")
    public Result page(@RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current,
                       @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size, SysUser entity) {
        Page<SysUser> page = sysUserService.page(current, size, entity);
        // 字典值转字典文字
        page.getRecords().parallelStream().forEach(x -> {
            x.setSex(StrUtil.isNotEmpty(x.getSex()) ? sysDicService.getDictText(DictConstants.DICT_CODE_SEX, x.getSex()) : "");
        });
        return Result.success(page);
    }

    /*****
     * 保存用户信息
     * @param entity
     * @return
     */
    @RequestMapping("/save")
    public Result insert(@Valid SysUser entity) {
        // 获取用户信息
        SysUser sysUserInfo = SysUtil.getUser();
        if (StrUtil.isBlank(entity.getId())) {
            entity.setCreater(sysUserInfo.getUserId());
            entity.setUserId(IDUtil.uuid());
            Integer temp = sysUserService.insert(entity);
            if (temp == 0) {
                return Result.success("用户名重复");
            }
            return Result.success("新增成功");
        }

        // 修改用户
        entity.setUpdater(sysUserInfo.getUserId());
        Integer temp = sysUserService.updateById(entity);
        if (temp == 0) {
            return Result.success("用户名重复");
        }
        return Result.success("修改成功");
    }

    /**
     * 删除用户信息
     *
     * @param userId
     * @return
     */
    @RequestMapping("/delete")
//    @Log(model = "系统管理", des = "删除用户", type = OperateType.DELETE)
    public Result delete(String userId) {
        SysUser entity = sysUserService.getById(userId);
        if (entity != null && "admin".equals(entity.getUserName())) {
            return Result.fail("超级管理员不能删除");
        }
        boolean b = sysUserService.deleteById(userId);
        if (!b) {
            return Result.fail("删除失败");
        }
        return Result.success("删除成功");
    }

    /**
     * 获取用户信息
     *
     * @param userId
     * @return
     */
    @RequestMapping("/getById")
    public Result getByUserId(String userId) {
        SysUser entity = sysUserService.getById(userId);
        return Result.success(entity);
    }

    /**
     * 重置密码
     *
     * @param userId
     * @return
     */
    @RequestMapping("/resetPwd")
    public Result resetPwd(String userId) {
        boolean b = sysUserService.resetPwd(userId);
        return b ? Result.success("重置密码成功") : Result.fail("重置密码失败");
    }


    /**
     * 修改密码
     *
     * @param entity
     * @return
     */
    @RequestMapping("/updatePwd")
    public Result updatePwd(SysUser entity) {
        boolean res = sysUserService.updatePwd(entity);
        return res ? Result.success("修改成功") : Result.fail("原始密码错误");
    }

}
