package com.kdgcsoft.jt.xzzf.system.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.frame.constants.SystemConstants;
import com.kdgcsoft.jt.xzzf.system.entity.SysSubSystem;
import com.kdgcsoft.jt.xzzf.system.service.SysSubSystemService;
import com.kdgcsoft.jt.xzzf.system.service.SysSubSystemService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/****
 * @className SysSubSystemController
 * @author chris
 * @description 子系统Controller
 * @version 1.0
 * @date 2019-12-24 11:13
 */
@RestController
@RequestMapping("/sysSubSystem")
public class SysSubSystemController extends BaseController {

    @Resource
    private SysSubSystemService sysSubSystemService;

    /*****
     * 子系统信息分页查询
     * @param current 当前页
     * @param size    分页条数
     * @param entity
     * @return
     */
    @RequestMapping("/page")
    public Result pageData(@RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current, @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size, SysSubSystem entity) {
        Page<SysSubSystem> page = this.sysSubSystemService.page(current, size, entity);
        return Result.success(page);
    }

    /*****
     * 保存子系统信息
     * @param entity
     * @return
     */
    @RequestMapping("/save")
    public Result saveOrUpdate(@Valid SysSubSystem entity) {
        boolean isCreate = StrUtil.isBlank(entity.getId());
        this.sysSubSystemService.saveOrUpdate(entity, isCreate);
        return Result.success(isCreate ? "添加成功" : "修改成功");
    }

    /*****
     * 获取子系统信息
     * @param id 主键ID
     * @return
     */
    @RequestMapping("/detail")
    public Result getById(String id) {
        return Result.success(this.sysSubSystemService.getEntityById(id));
    }

    /*****
     * 删除子系统信息
     * @param ids 主键ID集合
     * @return
     */
    @RequestMapping("/delete")
    public Result delete(String ids) {
        this.sysSubSystemService.deleteDataByIds(ids);
        return Result.success("删除成功");
    }

    /*****
     * 子系统下拉框数据
     * @return
     */
    @RequestMapping("/combobox")
    public Result combobox(String filter) {
        return Result.success(this.sysSubSystemService.queryEntityCombobox(filter));
    }
}
