package com.kdgcsoft.jt.xzzf.system.controller;

import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleMenuService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/****
 * @className SysRoleMenuController
 * @author chris
 * @description 角色菜单控制层
 * @version 1.0
 * @date 2019-12-27 12:32
 */
@RestController
@RequestMapping("/sysRoleMenu")
public class SysRoleMenuController extends BaseController {

    @Resource
    private SysRoleMenuService sysRoleMenuService;

    /*****
     * 保存角色菜单信息
     * @param roleId 角色主键Id
     * @param menuIds 菜单主键Id集合
     * @return
     */
    @RequestMapping("/save")
    public Result saveRoleMenu(@RequestParam(required = true) String roleId,
                               @RequestParam(required = true) String menuIds) {
        this.sysRoleMenuService.saveRoleMenuRel(roleId, menuIds);
        return Result.success("保存成功");
    }

    /*****
     * 查询角色关联菜单信息
     * @param roleId 角色主键Id
     * @return
     */
    @RequestMapping("/queryRoleMenu")
    public Result queryRoleMenu(String roleId) {
        return Result.success(this.sysRoleMenuService.queryRoleMenuByRoleId(roleId));
    }
}
