package com.kdgcsoft.jt.xzzf.system.controller;


import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.frame.constants.SystemConstants;
import com.kdgcsoft.jt.xzzf.system.entity.SysRole;
import com.kdgcsoft.jt.xzzf.system.service.SysRoleService;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * <p>
 * 角色
 * </p>
 *
 * @author mapp
 * @date 2019-12-06
 */
@RestController
@RequestMapping("/sysRole")
public class SysRoleController extends BaseController {

    @Resource
    private SysRoleService sysRoleService;

    /*****
     * 角色信息分页查询
     * @param current 当前页
     * @param size 分页条数
     * @param entity
     * @return
     */
    @RequestMapping("/page")
    public Result page(@RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current,
                       @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size, SysRole entity) {
        Page<SysRole> page = sysRoleService.page(current, size, entity);
        return Result.success(page);
    }

    /*****
     * 保存角色信息
     * @param entity
     * @return
     */
    @RequestMapping("/save")
    public Result insert(SysRole entity) {
        boolean isCreate = StrUtil.isBlank(entity.getId());
        this.sysRoleService.saveOrUpdate(entity, isCreate);
        return Result.success(isCreate ? "添加成功" : "修改成功");
    }

    /*****
     * 获取角色信息
     * @param roleId
     * @return
     */
    @RequestMapping("/getById")
    public Result getById(String roleId) {
        SysRole entity = sysRoleService.getEntityById(roleId);
        return Result.success(entity);
    }

    /******
     * 删除角色信息
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    public Result delete(String ids) {
        this.sysRoleService.deleteDataByIds(ids);
        return Result.success("删除成功");
    }
//
//    /*****
//     * 保存用户角色
//     * @param userId
//     * @param roleIds
//     * @return
//     */
//    @RequestMapping("/saveUserRole")
//    public Result saveUserRole(@RequestParam(required = true) String userId,
//                               @RequestParam(required = true) String roleIds) {
//        return Result.result(sysRoleService.saveUserRole(userId, roleIds));
//    }
//
//    /****
//     * 查询用户角色
//     * @param userId
//     * @return
//     */
//    @RequestMapping("/queryUserRole")
//    public Result queryUserRole(String userId) {
//        return Result.success(sysRoleService.queryUserRole(userId));
//    }
//
//    /*****
//     * 保存角色信息
//     * @param entity
//     * @return
//     */
//    @RequestMapping("/save")
//    public Result insert(SysRole entity) {
//        if (StrUtil.isBlank(entity.getId())) {
//            entity.setId(IDUtil.uuid());
//            return Result.result(sysRoleService.insert(entity));
//        }
//        return Result.result(sysRoleService.updateById(entity));
//    }
}
