package com.kdgcsoft.jt.xzzf.system.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.enums.ResultCode;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.frame.constants.SystemConstants;
import com.kdgcsoft.jt.xzzf.system.entity.SysCode;
import com.kdgcsoft.jt.xzzf.system.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.system.entity.SysOrg;
import com.kdgcsoft.jt.xzzf.system.service.SysMenuService;
import com.kdgcsoft.jt.xzzf.system.service.SysOrgService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/****
 * @className SysOrgController
 * @author chris
 * @description 组织机构控制层
 * @version 1.0
 * @date 2019-12-23 09:48
 */
@RestController
@RequestMapping("/sysOrg")
public class SysOrgController extends BaseController {

    @Resource
    private SysOrgService sysOrgService;

    /**
     * 组织机构信息分页查询
     *
     * @param current 当前页
     * @param size    分页条数
     * @param sysOrg
     * @return
     */
    @RequestMapping("/page")
    public Result pageData(@RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current, @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size, SysOrg sysOrg) {
        Page<SysOrg> page = this.sysOrgService.page(current, size, sysOrg);
        return Result.success(page);
    }

    /*****
     * 保存组织机构信息
     * @param sysOrg
     * @return
     */
    @RequestMapping("/save")
    public Result saveOrUpdate(@Valid SysOrg sysOrg) {
        boolean isCreate = StrUtil.isBlank(sysOrg.getId());
        this.sysOrgService.saveOrUpdate(sysOrg, isCreate);
        return Result.success(isCreate ? "添加成功" : "修改成功");
    }

    /*****
     * 获取组织机构信息
     * @param id 主键ID
     * @return
     */
    @RequestMapping("/detail")
    public Result getById(String id) {
        SysOrg sysOrg = this.sysOrgService.getEntityById(id);
        if (ObjectUtil.isNotNull(sysOrg)) {
            return Result.success(sysOrg);
        } else {
            return Result.fail(0,"记录不存在,请重试");
        }
    }

    /**
     * 删除组织机构信息
     *
     * @param ids 主键ID集合
     * @return
     */
    @RequestMapping("/delete")
    public Result delete(String ids) {
        this.sysOrgService.deleteDataByIds(ids);
        return Result.success("删除成功");
    }

    /*****
     * 获取组织机构树数据
     * @return
     */
    @RequestMapping("/tree")
    public Result treeData() {
        List<SysOrg> treeList = this.sysOrgService.queryTreeData();
        return Result.success(treeList);
    }
}
