package com.kdgcsoft.jt.xzzf.system.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.entity.LoginUser;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.frame.constants.SystemConstants;
import com.kdgcsoft.jt.xzzf.system.entity.SysMenu;
import com.kdgcsoft.jt.xzzf.system.service.SysMenuService;
import com.kdgcsoft.scrdc.frame.webframe.core.config.shiro.ShiroKit;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;

/******
 * 菜单控制器
 * @author mapp
 * @date 2019-12-03
 */
@RestController
@RequestMapping("/sysMenu")
public class SysMenuController extends BaseController {

    @Resource
    private SysMenuService sysMenuService;

    /*****
     * 菜单信息分页查询
     * @param current 当前页
     * @param size    分页条数
     * @param entity
     * @return
     */
    @RequestMapping("/page")
    public Result page(@RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current,
                       @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size, SysMenu entity) {
        Page<SysMenu> page = sysMenuService.page(current, size, entity);
        return Result.success(page);
    }

    /*****
     * 保存菜单信息
     * @param entity
     * @return
     */
    @RequestMapping("/save")
    public Result insert(@Valid SysMenu entity) {
        boolean isCreate = StrUtil.isBlank(entity.getId());
        this.sysMenuService.saveOrUpdate(entity, isCreate);
        return Result.success(isCreate ? "添加成功" : "修改成功");
    }

    /*****
     * 删除菜单信息
     * @param ids
     * @return
     */
    @RequestMapping("/delete")
    public Result delete(String ids) {
        this.sysMenuService.deleteDataByIds(ids);
        return Result.success("删除成功");
    }

    /******
     * 获取菜单信息
     * @param menuId 菜单主键Id
     * @return
     */
    @RequestMapping("/getById")
    public Result getById(String menuId) {
        return Result.success(this.sysMenuService.getEntityById(menuId));
    }

    /******
     * 获取所有菜单
     * @param menu 实体类
     * @return
     */
    @RequestMapping("/list")
    public Result queryAllMenus(SysMenu menu) {
        return Result.success(this.sysMenuService.queryAllMenus(menu));
    }

    /*****
     * 查询用户菜单信息
     * @param userId
     * @return
     */
    @RequestMapping("/queryUserMenu")
    public Result queryUserMenu(String userId) {
        return Result.success(this.sysMenuService.queryUserMenuByUserId(userId));
    }

//    /*****
//     * 保存菜单信息
//     * @param entity
//     * @return
//     */
//    @RequestMapping("/save")
//    public Result insert(@Valid SysMenu entity) {
//        if (StrUtil.isBlank(entity.getId())) {
//            entity.setId(IDUtil.uuid());
//            Integer res = sysMenuService.insert(entity);
//            if (res == 0) {
//                return Result.success(res, "编码重复");
//            }
//            return Result.success(entity);
//        }
//        return Result.result(sysMenuService.updateById(entity));
//    }
//
//    /**
//     * 删除菜单信息
//     *
//     * @param menuId
//     * @return
//     */
//    @RequestMapping("/delete")
//    public Result delete(String menuId) {
//        Integer res = sysMenuService.deleteById(menuId);
//        if (res == 0) {
//            return Result.success(res, "菜单下有子菜单，不能删除");
//        }
//        return Result.success(res);
//    }
//
//
//    /**
//     * 保存角色菜单信息
//     *
//     * @param roleId
//     * @param menuIds
//     * @return
//     */
//    @RequestMapping("/saveRoleMenu")
//    public Result saveRoleMenu(@RequestParam(required = true) String roleId,
//                               @RequestParam(required = true) String menuIds) {
//        return Result.result(sysMenuService.saveRoleMenu(roleId, menuIds));
//    }
//
//
//    /**
//     * 查询角色菜单信息
//     *
//     * @param roleId
//     * @return
//     */
//    @RequestMapping("/queryRoleMenu")
//    public Result queryRoleMenu(String roleId) {
//        return Result.success(sysMenuService.queryRoleMenu(roleId));
//    }
}
