package com.kdgcsoft.jt.xzzf.system.controller;


import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.frame.constants.SystemConstants;
import com.kdgcsoft.jt.xzzf.frame.util.SysUtil;
import com.kdgcsoft.jt.xzzf.system.entity.SysDic;
import com.kdgcsoft.jt.xzzf.system.entity.SysUser;
import com.kdgcsoft.jt.xzzf.system.service.SysDicService;
import com.kdgcsoft.scrdc.frame.webframe.base.service.BaseDicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 字典管理接口
 * </p>
 *
 * @author zd
 * @date 2019-12-21
 */
@RestController
@RequestMapping("/dict")
public class SysDicController extends BaseController {

    @Autowired
    private SysDicService sysDicService;

    @Autowired
    private BaseDicService baseDicService;

    /**
     * 信息分页查询
     *
     * @param dicCode 字典编码
     * @param dicName 字典名称
     * @param dicText 字典文字
     * @param current 当前页
     * @param size    每页显示个数
     * @return
     */
    @RequestMapping("/page")
    public Result page(@RequestParam(value = "dicCode", required = false) String dicCode,
                       @RequestParam(value = "dicName", required = false) String dicName,
                       @RequestParam(value = "dicText", required = false) String dicText,
                       @RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current,
                       @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size) {
        SysDic sysDic = new SysDic();
        sysDic.setDicCode(dicCode);
        sysDic.setDicName(dicName);
        sysDic.setDicText(dicText);
        Page<SysDic> page = sysDicService.page(current, size, sysDic);
        return Result.success(page);
    }

    /**
     * 新增字典
     *
     * @param sysDic
     * @return 0：字典名称重复；1：字典编码重复；2字典新增成功
     */
    @RequestMapping(value = "/addDic", method = RequestMethod.POST)
    public Result addDic(SysDic sysDic) {
        // 获取用户信息
        SysUser sysUser = SysUtil.getUser();
        sysDic.setCreater(sysUser.getUserId());
        sysDic.setId(IDUtil.uuid());
        // 插入数据
        Integer count = sysDicService.insert(sysDic);
        if (count == 0) {
            return Result.fail("字典名称重复");
        } else if (count == 1) {
            return Result.fail("字典编码重复");
        } else {
            return Result.success("字典新增成功");
        }
    }

    /**
     * 新增、修改字典值
     *
     * @return 0：字典值重复；
     */
    @RequestMapping(value = "/saveDicValue", method = RequestMethod.POST)
    public Result saveDicValue(SysDic sysDic) {
        // 获取用户信息
        SysUser sysUser = SysUtil.getUser();
        if (StrUtil.isBlank(sysDic.getDicId())) {
            sysDic.setCreater(sysUser.getUserId());
            sysDic.setDicId(IDUtil.uuid());
            Integer count = sysDicService.addDicValue(sysDic);
            if (count == 0) {
                return Result.fail("字典值重复");
            }
            return Result.success("新增成功");
        }

        // 修改字典值
        sysDic.setUpdater(sysUser.getUserId());
        Integer count = sysDicService.updateById(sysDic);
        if (count == 0) {
            return Result.fail("字典值重复");
        }
        return Result.success("修改成功");
    }

    /**
     * 根据id获取字典信息
     *
     * @param id
     * @return
     */
    @RequestMapping("/getById")
    public Result getById(@RequestParam("dicId") String id) {
        SysDic sysDic = sysDicService.getById(id);
        return Result.success(sysDic);
    }

    /**
     * 根据id删除字典值（批量删除：多个id逗号分隔）
     *
     * @param ids
     * @return 0:成功，1：失败
     */
    @RequestMapping("/deleteByDicId")
    public Result deleteByDicId(@RequestParam("dicId") String ids) {
        Integer temp = sysDicService.deleteByDicId(ids);
        if (temp == 1) {
            return Result.fail("删除失败");
        }
        return Result.success("删除成功");
    }


    /**
     * 根据字典编码，查询字典并排序
     *
     * @param dictCode
     * @return
     */
    @RequestMapping("/getListByCode")
    public Result test(@RequestParam(value = "dictCode") String dictCode) {
        return Result.success(sysDicService.getListByCode(dictCode));
    }
}
