package com.kdgcsoft.jt.xzzf.system.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.frame.constants.SystemConstants;
import com.kdgcsoft.jt.xzzf.system.entity.SysDept;
import com.kdgcsoft.jt.xzzf.system.service.SysDeptService;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/****
 * @className SysDeptController
 * @author chris
 * @description 部门管理控制层
 * @version 1.0
 * @date 2019-12-23 19:38
 */
@RestController
@RequestMapping("/sysDept")
public class SysDeptController extends BaseController {

    @Resource
    private SysDeptService sysDeptService;

    /**
     * 部门信息分页查询
     *
     * @param current 当前页
     * @param size    分页条数
     * @param sysDept
     * @return
     */
    @RequestMapping("/page")
    public Result pageData(@RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current, @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size, SysDept sysDept) {
        Page<SysDept> page = this.sysDeptService.page(new Page<>(current, size), sysDept);
        return Result.success(page);
    }

    /*****
     * 保存部门信息
     * @param sysDept
     * @return
     */
    @RequestMapping("/save")
    public Result saveOrUpdate(@Valid SysDept sysDept) {
        boolean isCreate = StrUtil.isBlank(sysDept.getId());
        this.sysDeptService.saveOrUpdate(sysDept, isCreate);
        return Result.success(isCreate ? "添加成功" : "修改成功");
    }

    /*****
     * 获取部门信息
     * @param id 主键ID
     * @return
     */
    @RequestMapping("/detail")
    public Result getById(String id) {
        return Result.success(this.sysDeptService.getEntityById(id));
    }

    /**
     * 删除部门信息
     *
     * @param ids 主键ID集合
     * @return
     */
    @RequestMapping("/delete")
    public Result delete(String ids) {
        this.sysDeptService.deleteDataByIds(ids);
        return Result.success("删除成功");
    }

    /*****
     * 获取部门树数据
     * @return
     */
    @RequestMapping("/tree")
    public Result treeData() {
        List<SysDept> treeList = this.sysDeptService.queryTreeData();
        return Result.success(treeList);
    }
}
