package com.kdgcsoft.jt.xzzf.system.controller;


import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.frame.constants.SystemConstants;
import com.kdgcsoft.jt.xzzf.system.entity.SysCodeType;
import com.kdgcsoft.jt.xzzf.system.service.SysCodeTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * <p>
 * 编码类别
 * </p>
 *
 * @author mapp
 * @date 2019-12-10
 */
@RestController
@RequestMapping("/sysCodeType")
public class SysCodeTypeController extends BaseController {

    @Autowired
    private SysCodeTypeService sysCodeTypeService;

    /**
     *  编码类别信息分页查询
     *
     * @param current 当前页
     * @param size 分页条数
     * @param sysCodeType
     * @return
     */
    @RequestMapping("/page")
    public Result page(@RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current,
                       @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size, SysCodeType sysCodeType) {
        Page<SysCodeType> page = sysCodeTypeService.page(current, size, sysCodeType);
        return Result.success(page);
    }

    /**
     * 保存编码类别信息
     *
     * @param sysCodeType
     * @return
     */
    @RequestMapping("/save")
    public Result insert(@Valid SysCodeType sysCodeType) {
        if (StrUtil.isBlank(sysCodeType.getId())) {
           sysCodeType.setId(IDUtil.uuid());
            Integer res = sysCodeTypeService.insert(sysCodeType);
            if (res == 0) {
                return Result.success(res, "编码类别重复");
            }
            return Result.success(res);
        }

        Integer res = sysCodeTypeService.updateById(sysCodeType);
        if (res == 0) {
            return Result.success(res, "编码类别重复");
        }
        return Result.success(res);
    }

    /**
     * 删除编码类别信息
     *
     * @param codeTypeId
     * @return
     */
    @RequestMapping("/delete")
    public Result delete(String codeTypeId) {
        return Result.result(sysCodeTypeService.deleteById(codeTypeId));
    }

    /**
     * 获取编码类别信息
     *
     * @param codeTypeId
     * @return
     */
    @RequestMapping("/getById")
    public Result getById(String codeTypeId) {
        SysCodeType sysCodeType = sysCodeTypeService.getById(codeTypeId);
        return Result.success(sysCodeType);
    }
}
