package com.kdgcsoft.jt.xzzf.system.controller;


import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.controller.BaseController;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.common.util.IDUtil;
import com.kdgcsoft.jt.xzzf.frame.constants.SystemConstants;
import com.kdgcsoft.jt.xzzf.system.entity.SysCode;
import com.kdgcsoft.jt.xzzf.system.service.SysCodeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;

import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

/**
 * <p>
 * 系统编码表
 * </p>
 *
 * @author mapp
 * @date 2019-12-10
 */
@RestController
@RequestMapping("/sysCode")
public class SysCodeController extends BaseController {

    @Autowired
    private SysCodeService sysCodeService;

    /**
     *  系统编码表信息分页查询
     *
     * @param current 当前页
     * @param size 分页条数
     * @param sysCode
     * @return
     */
    @RequestMapping("/page")
    public Result page(@RequestParam(defaultValue = SystemConstants.PAGE_CUR_DEF_VALUE) long current,
                       @RequestParam(defaultValue = SystemConstants.PAGE_SIZE_DEF_VALUE) long size, SysCode sysCode) {
        Page<SysCode> page = sysCodeService.page(current, size, sysCode);
        return Result.success(page);
    }

    /**
     * 保存系统编码表信息
     *
     * @param sysCode
     * @return
     */
    @RequestMapping("/save")
    public Result insert(@Valid SysCode sysCode) {
        if (StrUtil.isBlank(sysCode.getId())) {
           sysCode.setId(IDUtil.uuid());
            Integer res = sysCodeService.insert(sysCode);
            if (res == 0) {
                return Result.success(res, "编码重复");
            }
            return Result.success(res);
        }

        Integer res = sysCodeService.updateById(sysCode);
        if (res == 0) {
            return Result.success(res, "编码重复");
        }
        return Result.success(res);
    }

    /**
     * 删除编码信息
     *
     * @param codeId
     * @return
     */
    @RequestMapping("/delete")
    public Result delete(String codeId) {
        return Result.result(sysCodeService.deleteById(codeId));
    }

    /**
     * 获取系统编码表信息
     *
     * @param codeId
     * @return
     */
    @RequestMapping("/getById")
    public Result getById(String codeId) {
        SysCode sysCode = sysCodeService.getById(codeId);
        return Result.success(sysCode);
    }

    /**
     * 根据编码类别ID 或者 编码类别代码 获取 编码
     *
     * @param codeTypeId 编码类别ID
     * @param codeTableCode 编码类别代码物理名
     * @return
     */
    @RequestMapping("/getByCodeType")
    public Result getCodeByCodeType(String codeTypeId, String codeTableCode) {
        return success(sysCodeService.getCodeByCodeType(codeTypeId, codeTableCode));
    }
}
