package com.kdgcsoft.jt.xzzf.frame.shiro;

import cn.hutool.core.map.MapUtil;
import com.kdgcsoft.jt.xzzf.common.config.XzzfProperties;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.interfaces.FrameExtConfig;
import org.apache.shiro.cas.CasFilter;
import org.apache.shiro.web.filter.authc.LogoutFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import javax.servlet.Filter;
import java.util.Map;

@Configuration
public class ExampleConfig implements FrameExtConfig, WebMvcConfigurer {

    private static final Logger LOG = LoggerFactory.getLogger(ExampleConfig.class);

    @Autowired
    private XzzfProperties xzzfProperties;
    @Override
    public String modelCode() {
        return "system";
    }

    @Override
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler("/**").addResourceLocations("file:./login/");
        registry.addResourceHandler("/icon/**").addResourceLocations("classpath:/icon/");
    }

    @Override
    public Class shiroRealm() {
        return xzzfProperties.isCasEnable() ? CasShiroRealm.class : null;
    }

    @Override
    public Map<String, String> shiroFilterChain() {
        Map<String, String> map = MapUtil.newHashMap(true);
        if (xzzfProperties.isCasEnable()) {
            map.put("/toIndex", "casFilter");
            map.put("/logout", "logoutFilter");
            map.put("/error", "anon");
        }
        map.put("/toLogin", "anon");
        map.put("/login.html", "anon");
        map.put("/css/**", "anon");
        map.put("/images/**", "anon");
        return map;
    }

    @Override
    public Map<String, Filter> shiroFilters() {
        Map<String, Filter> map = MapUtil.newHashMap();
        CasFilter casFilter = new CasFilter();
        casFilter.setFailureUrl("/error");
        map.put("casFilter", casFilter);
        LogoutFilter logoutFilter = new LogoutFilter();
        logoutFilter.setRedirectUrl(xzzfProperties.getCasServerUrl() + "logout?service=" + xzzfProperties.getService());
        map.put("logoutFilter", logoutFilter);
        return xzzfProperties.isCasEnable() ? map : null;
    }

    @Override
    public String shiroLoginUrl() {
        String url = xzzfProperties.getCasServerUrl() + "login?service=" + xzzfProperties.getService() + "toIndex";
        return xzzfProperties.isCasEnable() ? url : null;
    }
}
