package com.kdgcsoft.jt.xzzf.frame.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.type.JdbcType;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.config.GlobalConfig.DbConfig;
import com.baomidou.mybatisplus.extension.MybatisMapWrapperFactory;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;

/**
 *
 * mybatis-plus 配置
 *
 *
 * @author zouye
 * @date 2019/2/14
 */
@Configuration
@MapperScan(basePackages = { "com.kdgcsoft.jt.xzzf.system.document.mapperdocument" }, sqlSessionFactoryRef = "documentSessionFactory")
public class DocumentConfig {

	private String mapperLocations = "classpath:mapper_document/*.xml";

	@Autowired
    public PaginationInterceptor paginationInterceptor;
	
	@Bean(name = "documentSessionFactory")
	public MybatisSqlSessionFactoryBean sessionFactory() throws IOException {
		MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
		factoryBean.setDataSource(dataSourceDocument());

		// 设置xml文件所在位置
		ResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
		System.out.println("mapperLocations: " + mapperLocations);
		Resource[] resource = resolver.getResources(mapperLocations);
		// 添加分页插件
		factoryBean.setMapperLocations(resource);
		factoryBean.setTypeAliasesPackage("com.kdgcsoft.jt.xzzf.system.document.entity");

		 // 添加分页插件
        List<Interceptor> interceptors = new ArrayList<>();
        interceptors.add(paginationInterceptor);
        Interceptor[] arr = new Interceptor[interceptors.size()];

        factoryBean.setMapperLocations(resource);
        factoryBean.setPlugins(interceptors.toArray(arr));
        
		GlobalConfig config = new GlobalConfig();
		// 自动填充
		config.setBanner(false);
		config.setDatacenterId(0L);
		config.setWorkerId(0L);
		DbConfig dbconfig = new DbConfig();
		dbconfig.setLogicDeleteValue("1");
		dbconfig.setLogicNotDeleteValue("0");
		dbconfig.setIdType(IdType.ID_WORKER);
		config.setDbConfig(dbconfig);
		factoryBean.setGlobalConfig(config);

		MybatisConfiguration configuration = new MybatisConfiguration();
		configuration.setJdbcTypeForNull(JdbcType.NULL);
		configuration.setMapUnderscoreToCamelCase(true);
		configuration.setGlobalConfig(config);
		configuration.setCallSettersOnNulls(true);
		factoryBean.setConfiguration(configuration);
		factoryBean.setObjectWrapperFactory(new MybatisMapWrapperFactory());
		return factoryBean;
	}

	@Bean(name = "dataSourceDocument")
	@ConfigurationProperties(prefix = "spring.datasourcedocument")
	public DataSource dataSourceDocument() {
		return DataSourceBuilder.create().build();
	}
}
