package com.kdgcsoft.scrdc.frame.webframe.core.service;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.*;
import cn.hutool.db.dialect.DialectFactory;
import com.kdgcsoft.scrdc.frame.webframe.base.dao.*;
import com.kdgcsoft.scrdc.frame.webframe.base.entity.*;
import com.kdgcsoft.scrdc.frame.webframe.core.cnst.FrameConst;
import com.kdgcsoft.scrdc.frame.webframe.core.dao.BaseInfoDao;
import com.kdgcsoft.scrdc.frame.webframe.core.entity.BaseInfo;
import com.kdgcsoft.scrdc.frame.webframe.core.entity.StateEnum;
import com.kdgcsoft.scrdc.frame.webframe.core.exception.FrameException;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.*;
import com.kdgcsoft.scrdc.frame.webframe.core.extend.interfaces.FrameExtConfig;
import com.kdgcsoft.scrdc.frame.webframe.core.helper.MenuBtnScaner;
import com.kdgcsoft.scrdc.frame.webframe.core.helper.ScriptRunner;
import com.kdgcsoft.scrdc.frame.webframe.core.model.LoginUser;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.servlet.Filter;
import javax.sql.DataSource;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.*;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/**
 * @description:
 * @author: fyin
 * @date: 2018/10/8/008 11:14
 * @version: 1.0
 **/
@Slf4j
public class FrameService {
    public static final String BASE_PACKAGE = "com";
    /**
     * 初始化表名
     */
    public static final String BASE_INFO = "base_info";
    
    /**
     * 初始化sql文件后缀
     */
    public static final String SQL_SUFFIX = "sql";
    /**
     * 属性值字段名
     */
    public static final String KEY_COLUMN = "info_Key";
    /**
     * 是否已经初始化过
     */
    public static final String KEY_INITED = "INITED";
    /**
     * 初始化后的值
     */
    public static final String INITED_FLAG = "1";
    
    public static final String UPDATE_XML = "META-INF/update/update.xml";
    /**
     * 系统的数据源
     */
    private DataSource dataSource;
    /**
     * 系统数据库类型
     */
    private String dbType;
    
    
    /**
     * 系统是否已经初始化过
     */
    private boolean inited;
    
    /**
     * 系统是否需要升级
     **/
    private boolean needUpdate;
    
    private ConfigurableApplicationContext configurableContext;
    
    private BaseLoggersDao loggersDao;
    private BaseInfoDao baseInfoDao;
    private BaseMenuDao menuDao;
    private BaseMenuBtnDao menuBtnDao;
    private BaseDicDao dicDao;
    private BaseVersionDao versionDao;
    private BasePermissionDao permissionDao;
    
    
    private List<FrameExtConfig> extConfigList = new ArrayList<>();
    private Map<String, InitParam> initParamsMap = new LinkedHashMap<>();
    private List<InitSql> initSqlList = new ArrayList<>();
    private Map<String, List<Version>> versionMap = new HashMap<>();
    
    private Map<String, FrameModel> modelMap = new HashMap<>();
    
    private List<EmbedMenu> embedMenuList = new ArrayList<>();
    private List<EmbedMenuBtn> embedBtnList = new ArrayList<>();
    private List<String> menuCodeList = new ArrayList<>();
    
    private Map<String, EmbedDic> embedDicMap = new LinkedHashMap<>();
    private List<EmbedNavMenu> navList = new LinkedList<>();
    private List<EmbedNavMenu> leftNavList = new LinkedList<>();
    private List<EmbedNavMenu> rightNavList = new LinkedList<>();
    
    private Map<String, String> shiroFilterChainMap = new HashMap<>();
    private Map<String, Filter> shiroFilters = new HashMap<>();
    private Map<String, Class> beetlTagMap = new HashMap<>();
    private String shiroLoginUrl;
    private Class realmClass;
    // all realms
    private List<Class> realmClassList = new ArrayList<>();

    private List<EmbedTheme> themeList = new ArrayList<>();
    private List<String> indexJsList = new ArrayList<>();
    private Map<String, Boolean> permissionMap = new HashMap<>();
    
    
    public FrameService(DataSource dataSource, ConfigurableApplicationContext configurableContext) throws SQLException {
        this.dataSource = dataSource;
        this.configurableContext = configurableContext;
        //检测数据库类型
        this.dbType = DialectFactory.getDialect(dataSource)
                                    .dialectName()
                                    .name()
                                    .toLowerCase();
        this.loggersDao = configurableContext.getBean(BaseLoggersDao.class);
        this.baseInfoDao = configurableContext.getBean(BaseInfoDao.class);
        this.menuDao = configurableContext.getBean(BaseMenuDao.class);
        this.dicDao = configurableContext.getBean(BaseDicDao.class);
        this.menuBtnDao = configurableContext.getBean(BaseMenuBtnDao.class);
        this.versionDao = configurableContext.getBean(BaseVersionDao.class);
        this.permissionDao = configurableContext.getBean(BasePermissionDao.class);
        this.inited = checkInited();
        /**同步日志配置信息**/
//        syncLogSettings();
        /**从配置文件中加载模块信息**/
//        loadFrameModelFormXML();
        /**
         * 扫描配置类
         */
        scanConfigClass();
        
        /**同步版本信息****/
        if (this.inited) {
//            syncModelVersion();
            /**检测是否需要更新**/
//            checkUpdateState();
        }
        
        /***
         * 加载配置类
         */
        loadConfig();
        
        
        /**进行后台更新**/
//        updateBackground();
        
        /**加载内置菜单按钮**/
//        loadMenuBtns();
        
        /***
         * 同步到数据库
         */
//        syncConfig();
        
        
        /**
         * 未初始化过则加载初始化sql
         */
        if (!this.inited) {
//            loadInitSql();
        }
        /**
         * 加载完设置之后进行一些属性的调整
         */
        afterConfig();
        
        sortConfigData();
        
        if (this.inited) {
//            loadPermission();
            afterInited();
        }
        
    }
    
    
    /**
     * 重启系统
     */
    public void restart() {
        Class mainClass = null;
        Map<String, Object> classes = configurableContext.getBeansWithAnnotation(SpringBootApplication.class);
        for (Object o : classes.values()) {
            Class target = AopUtils.getTargetClass(o);
            mainClass = target.getSuperclass();
        }
        
        ApplicationArguments startargs = configurableContext.getBean(ApplicationArguments.class);
        
        configurableContext.close();
        configurableContext = SpringApplication.run(mainClass, startargs.getSourceArgs());
    }
    
    
    private void scanConfigClass() {
        for (Class clazz : ClassUtil.scanPackageBySuper(BASE_PACKAGE, FrameExtConfig.class)) {
            if (clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                continue;
            }
            try {
                FrameExtConfig extConfig = (FrameExtConfig) configurableContext.getBean(clazz);
                extConfigList.add(extConfig);
            } catch (Exception e) {
                throw new FrameException(e.getMessage(), e);
            }
        }
        
        /**对扩展类进行排序**/
        CollUtil.sort(extConfigList, Comparator.comparingInt(FrameExtConfig::order));
    }
    
    public void loadConfig() {
        for (FrameExtConfig extConfig : extConfigList) {
            
            /**加载扩展初始化参数**/
            List<InitParam> extInitParamList = extConfig.initParams();
            if (CollUtil.isNotEmpty(extInitParamList)) {
                for (InitParam initParam : extInitParamList) {
                    if (!initParamsMap.containsKey(initParam.getKey())) {
                        initParamsMap.put(initParam.getKey(), initParam);
                    } else {
                        log.error("初始化参数的key[{}]已经存在,请换用其他的key值", initParam.getKey());
                    }
                }
            }
            
            /***加载内置菜单**/
            List<EmbedMenu> embedMenus = extConfig.embedMenu();
            /**包含重复菜单则当前配置类中的所有菜单都不会加载**/
            if (checkRepeatMenu(embedMenus)) {
                log.error("{} 包含重复EmbedMenu,{}中的所有EmbedMenu 将不会加载,请修改menucode", extConfig.getClass()
                                                                                         .getName());
            } else {
                if (CollUtil.isNotEmpty(embedMenus)) {
                    embedMenuList.addAll(embedMenus);
                }
            }
            
            
            /***加载内置字典***/
            List<EmbedDic> dicList = extConfig.embedDic();
            if (CollUtil.isNotEmpty(dicList)) {
                for (EmbedDic dic : dicList) {
                    if (embedDicMap.containsKey(dic.getDicCode())) {
                        log.error("内置字典编码 diccode[{}]已经存在,请换用其他的值", dic.getDicCode());
                    } else {
                        embedDicMap.put(dic.getDicCode(), dic);
                    }
                }
            }
            
            /***加载内置主题***/
            List<EmbedTheme> themes = extConfig.embedTheme();
            if (CollUtil.isNotEmpty(themes)) {
                for (EmbedTheme theme : themes) {
                    themeList.add(theme);
                }
            }
            
            /**加载顶部功能菜单**/
            List<EmbedNavMenu> navMenuList = extConfig.embedNavMenus();
            if (CollUtil.isNotEmpty(navMenuList)) {
                for (EmbedNavMenu nav : navMenuList) {
                    navList.add(nav);
                    switch (nav.getNavType()) {
                        case RIGHT:
                            rightNavList.add(nav);
                            break;
                        case LEFT:
                            rightNavList.add(nav);
                            break;
                    }
                }
            }
            /**加载首页扩展js**/
            List<String> indexjs = extConfig.customIndexJs();
            if (CollUtil.isNotEmpty(indexjs)) {
                indexJsList.addAll(indexjs);
            }
            
            
            /**
             * 会按顺序覆盖shiroRealm
             */
            if (extConfig.shiroRealm() != null) {
                realmClass = extConfig.shiroRealm();
                // 增加多realm认证需求，一个认证通过即可
                realmClassList.add(extConfig.shiroRealm());
            }
            if (extConfig.shiroFilters() != null) {
                shiroFilters.putAll(extConfig.shiroFilters());
            }
            
            if (StrUtil.isNotEmpty(extConfig.shiroLoginUrl())) {
                shiroLoginUrl = extConfig.shiroLoginUrl();
            }
            
            /**扩展shiro过滤器**/
            if (MapUtil.isNotEmpty(extConfig.shiroFilterChain())) {
                shiroFilterChainMap.putAll(extConfig.shiroFilterChain());
            }
            /** 加载beetlTag */
            if (MapUtil.isNotEmpty(extConfig.beetlTag())) {
                beetlTagMap.putAll(extConfig.beetlTag());
            }
        }
        
    }
    
    private void syncConfig() {
        if (this.inited) {
            /**同步初始化参数的**/
            syncInitParams();
            /**同步菜单到数据库**/
            syncEmbedMenus();
            /**同步菜单到数据库**/
            syncEmbedMenuBtns();
            /**同步字典到数据库**/
            syncEmbedDics();
        }
    }
    
    /**
     * 加载完设置之后进行一些属性的调整
     */
    private void afterConfig() {
        /**按序加载扩展配置***/
        for (FrameExtConfig extendConfig : extConfigList) {
            extendConfig.afterConfig(this);
        }
    }
    
    /**
     * 系统初始化之后调用
     */
    public void afterInited() {
        /**按序加载扩展配置***/
        for (FrameExtConfig extendConfig : extConfigList) {
            extendConfig.afterInited(this);
        }
    }
    
    /**
     * 系统更新之后做的操作
     */
    public void afterUpdated() {
        /**按序加载扩展配置***/
        for (FrameExtConfig extendConfig : extConfigList) {
            extendConfig.afterUpdated(this);
        }
    }
    
    /**
     * 同步日志设置
     **/
    public void syncLogSettings() {
        if (this.inited) {
            LoggerContext loggerContext = (LoggerContext) LoggerFactory.getILoggerFactory();
            List<BaseLoggers> loggerlist = loggersDao.selectList(null);
            for (BaseLoggers logger : loggerlist) {
                Logger log = loggerContext.getLogger(logger.getName());
                if (log != null) {
                    if (FrameConst.Y == logger.getState()) {
                        log.setLevel(Level.valueOf(logger.getLevel()));
                    } else {
                        log.setLevel(null);
                    }
                    
                }
            }
        }
    }
    
    /**
     * 同步字典数据到数据库
     */
    public void syncEmbedDics() {
        List<BaseDic> dbdiclist = dicDao.findByLogicDelete(LogicDelete.N);
        List<BaseDic> changeList = new ArrayList<>();
        for (EmbedDic dic : embedDicMap.values()) {
            Map<String, String> values = dic.getValues();
            for (String value : values.keySet()) {
                BaseDic basedic = CollUtil.findOne(dbdiclist, new cn.hutool.core.lang.Filter<BaseDic>() {
                    @Override
                    public boolean accept(BaseDic baseDic) {
                        if (StrUtil.equals(baseDic.getDicCode(), dic.getDicCode()) && StrUtil.equals(baseDic.getDicValue(), value)) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                });
                if (basedic == null) {
                    basedic = new BaseDic();
                    basedic.setDicCode(dic.getDicCode());
                    basedic.setDicName(dic.getDicName());
                    basedic.setDicText(values.get(value));
                    basedic.setDicValue(value);
                    basedic.setDicType(BaseDic.DicType.EMBED);
                    changeList.add(basedic);
                }
            }
        }
		for (BaseDic baseDic : changeList) {
			if(baseDic.getDicId() == null){
				dicDao.insert(baseDic);
			}else{
				dicDao.updateById(baseDic);
			}
		}
    }
    
    /**
     * 同步内置菜单到数据库
     */
    public void syncEmbedMenus() {
        List<BaseMenu> menuList = menuDao.selectList(null);
        buildMenuWithDb(embedMenuList, menuList, 0L);
    }
    
    /**
     * 同步按钮到数据库,扫描到重复的不会重复加载
     */
    public void syncEmbedMenuBtns() {
        List<BaseMenuBtn> btnlist = menuBtnDao.selectList(null);
        for (BaseMenuBtn dbbtn : btnlist) {
            //移除扫描列表中已经不存在的按钮
            if (CollUtil.findOneByField(this.embedBtnList, "btnCode", dbbtn.getBtnCode()) == null) {
                menuBtnDao.deleteById(dbbtn);
            }
        }

        List<BaseMenu> menuList = menuDao.selectList(null);
        List<String> btncache = new ArrayList<>();
        for (EmbedMenuBtn btn : this.embedBtnList) {
            String menuCode = "";
            String btnCode = btn.getBtnCode();
            String btnName = btn.getBtnName();
            if (StrUtil.isNotEmpty(btn.getBtnCode())) {
                menuCode = StrUtil.subBefore(btn.getBtnCode(), ".", false);
            } else {
                log.warn("按钮{},无法识别", btn.toString());
            }
            if (StrUtil.isNotEmpty(menuCode) && StrUtil.isNotEmpty(btnCode) && StrUtil.isNotEmpty(btnName)) {
                if (btncache.contains(btnCode)) {
                    log.warn("按钮{}按钮编码重复,不会重复加载", btn.toString());
                } else {
                    btncache.add(btnCode);
                    saveMenuBtnToDb(menuList, btn);
                }
            }
            
        }
    }
    
    private void saveMenuBtnToDb(List<BaseMenu> menuList, EmbedMenuBtn btn) {
        String menuCode = "";
        String btnCode = btn.getBtnCode();
        String btnName = btn.getBtnName();
        if (StrUtil.isNotEmpty(btn.getBtnCode())) {
            menuCode = StrUtil.subBefore(btn.getBtnCode(), ".", false);
        } else {
            log.warn("按钮{},无法识别", btn.toString());
        }
        if (StrUtil.isNotEmpty(menuCode) && StrUtil.isNotEmpty(btnCode) && StrUtil.isNotEmpty(btnName)) {
            BaseMenu btnbelongMenu = CollUtil.findOneByField(menuList, "menuCode", menuCode);
            if (btnbelongMenu != null) {
                BaseMenuBtn dbbtn = menuBtnDao.findByMenuCodeAndBtnCodeAndLogicDelete(menuCode, btnCode, LogicDelete.N);
                if (dbbtn != null) {
                    if (!StrUtil.equals(btnName, dbbtn.getBtnName())) {
                        dbbtn.setBtnName(btnName);
                        menuBtnDao.updateById(dbbtn);
                    }
                } else {
                    BaseMenuBtn newbtn = new BaseMenuBtn();
                    newbtn.setBtnName(btnName);
                    newbtn.setMenuCode(menuCode);
                    newbtn.setBtnCode(btnCode);
                    menuBtnDao.insert(newbtn);
                }
            } else {
                //log.warn("按钮{}没有找到匹配的菜单,不会加载", btn.toString());
                // 找不到匹配的菜单，按照权限来处理
                String[] parts = btnCode.split("\\.");
                StringBuilder code = new StringBuilder();
                Long pid = 0L;
                
                for (String part : parts) {
                    code.append((code.length() == 0) ? part : "." + part);
                    String curCode = code.toString();
                    BasePermission p = permissionDao.findFirstByPermCode(curCode);
                    
                    if (null == p) {
                        p = new BasePermission();
                    }
                 
                    p.setPermCode(curCode);
                    p.setPermName(curCode.equals(btnCode) ? btnName : "");
                    p.setPermPid(pid);
                    p.setCreateTime(new Date());
                    if(p.getPermId() == null){
                    	permissionDao.insert(p);
					}else {
						permissionDao.updateById(p);
					}
                    pid = p.getPermId();
                }
            }
        } else {
            log.warn("按钮{}存在属性缺失,不会加载", btn.toString());
        }
    }
    
    private void buildMenuWithDb(List<EmbedMenu> menuList, List<BaseMenu> dbmenuList, long pid) {
        for (EmbedMenu embedMenu : menuList) {
            BaseMenu dbmenu = CollUtil.findOneByField(dbmenuList, "menuCode", embedMenu.getMenuCode());
            if (dbmenu != null) {
                if (!StrUtil.equals(embedMenu.getUrl(), dbmenu.getMenuUrl())) {
                    dbmenu.setMenuUrl(embedMenu.getUrl());
                    menuDao.updateById(dbmenu);
                }
            } else {
                dbmenu = new BaseMenu();
                dbmenu.setMenuCode(embedMenu.getMenuCode());
                dbmenu.setMenuUrl(embedMenu.getUrl());
                dbmenu.setMenuName(embedMenu.getName());
                dbmenu.setMenuIco(embedMenu.getIcon());
                dbmenu.setOrderNo(embedMenu.getOrder());
                dbmenu.setMenuType(BaseMenu.MenuType.EMBED);
                dbmenu.setMenuState(FrameConst.Y);
                dbmenu.setOpenType(0);
                dbmenu.setMenuPid(pid);
                menuDao.insert(dbmenu);
            }
            
            if (CollUtil.isNotEmpty(embedMenu.getChildren())) {
                buildMenuWithDb(embedMenu.getChildren(), dbmenuList, dbmenu.getMenuId());
            }
        }
    }
    
    
    /**
     * 查看有没有重复菜单
     *
     * @param menulist
     * @return
     */
    private boolean checkRepeatMenu(List<EmbedMenu> menulist) {
        if (CollUtil.isEmpty(menulist)) {
            return false;
        } else {
            for (EmbedMenu childmenu : menulist) {
                if (menuCodeList.contains(childmenu.getMenuCode())) {
                    log.error("内置菜单编码[{}]重复,请换用其他的menuCode", childmenu.getMenuCode());
                    return true;
                } else {
                    menuCodeList.add(childmenu.getMenuCode());
                    return checkRepeatMenu(childmenu.getChildren());
                }
            }
            return false;
        }
    }
    
    private void sortEmbedMenus(List<EmbedMenu> menulist) {
        if (CollUtil.isNotEmpty(menulist)) {
            CollUtil.sort(menulist, Comparator.comparingInt(EmbedMenu::getOrder));
            for (EmbedMenu menu : menulist) {
                sortEmbedMenus(menu.getChildren());
            }
        }
    }
    
    /**
     * 加载初始化sql文件
     *
     * @return
     */
    private void loadInitSql() {
        String basepath = "META-INF/init/";
        basepath = basepath + this.dbType;
        List<URL> resourcelist = ResourceUtil.getResources(basepath);
        for (URL url : resourcelist) {
            if ("file".equals(url.getProtocol())) {
                List<File> fileList = FileUtil.loopFiles(new File(url.getFile()));
                for (File file : fileList) {
                    if (!SQL_SUFFIX.equalsIgnoreCase(FileUtil.extName(file))) {
                        continue;
                    }
                    InitSql sql = new InitSql();
                    sql.setSqlName(file.getName());
                    sql.setPathType("file");
                    sql.setSqlPath(file.getAbsolutePath());
                    sql.setDownloadPath(Base64.encode(file.getAbsolutePath()));
                    this.initSqlList.add(sql);
                }
            } else if ("jar".equals(url.getProtocol())) {
                try (JarFile jarFile = URLUtil.getJarFile(url)) {
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    while (jarEntries.hasMoreElements()) {
                        JarEntry jarEntry = jarEntries.nextElement();
                        String resourceName = jarEntry.getName();
                        if (!StrUtil.startWithIgnoreCase(resourceName, basepath) || !StrUtil.endWithIgnoreCase(resourceName, "." + SQL_SUFFIX)) {
                            continue;
                        }
                        File jarfile = new File(jarFile.getName());
                        InitSql sql = new InitSql();
                        sql.setSqlName(StrUtil.subAfter(resourceName, "/", true));
                        sql.setPathType("jar");
                        sql.setSqlPath(jarfile.getName() + "/" + resourceName);
                        sql.setDownloadPath(Base64.encode(resourceName));
                        this.initSqlList.add(sql);
                    }
                } catch (Exception e) {
                    log.error("Loading init SQL Error:" + e.getMessage(), e);
                }
            }
        }
    }
    
    /**
     * 从数据库加载参数的值
     *
     * @throws SQLException
     */
    private void syncInitParams() {
        /**已经初始化就从数据库取值**/
        List<BaseInfo> dbinfolist = baseInfoDao.selectList(null);
        for (InitParam params : this.initParamsMap.values()) {
            BaseInfo dbinfo = CollUtil.findOneByField(dbinfolist, "infoKey", params.getKey());
            if (dbinfo != null && dbinfo.getInfoValue() != null && dbinfo.getInfoValue().length > 0) {
                params.setValue(dbinfo.getInfoValue());
                params.setStrValue(dbinfo.getInfoValueStr());
            }
        }
    }
    
    private void sortConfigData() {
        /**排序菜单**/
        sortEmbedMenus(this.embedMenuList);
        /**排序主题**/
        CollUtil.sort(this.themeList, Comparator.comparingInt(EmbedTheme::getOrder));
        
        /**排序顶部菜单**/
        CollUtil.sort(this.leftNavList, Comparator.comparingInt(EmbedNavMenu::getOrder));
        CollUtil.sort(this.rightNavList, Comparator.comparingInt(EmbedNavMenu::getOrder));
    }
    
    private void loadMenuBtns() {
        loadEmbedMenuBtns(this.embedMenuList);
        loadMenuBtnFormFile();
    }
    
    private void loadEmbedMenuBtns(List<EmbedMenu> menulist) {
        for (EmbedMenu menu : menulist) {
            if (CollUtil.isNotEmpty(menu.getBtnList())) {
                this.embedBtnList.addAll(menu.getBtnList());
            }
            if (CollUtil.isNotEmpty(menu.getChildren())) {
                loadEmbedMenuBtns(menu.getChildren());
            }
        }
    }
    
    public void loadPermission() {
        permissionMap.clear();
        List<BaseMenu> menuList = menuDao.findByLogicDeleteOrderByOrderNo(LogicDelete.N);
        for (BaseMenu menu : menuList) {
            /**菜单权限只加载启用的*/
            if (menu.getMenuState() == 1) {
                permissionMap.put(menu.getMenuCode(), true);
            }
        }
        List<BaseMenuBtn> btnList = menuBtnDao.selectList(null);
        for (BaseMenuBtn btn : btnList) {
            if (btn.getBtnState() == StateEnum.Y) {
                permissionMap.put(btn.getBtnCode(), true);
            }
        }
    }
    
    public boolean existPermission(String permissionCode) {
        return permissionMap.containsKey(permissionCode);
    }
    
    private void loadMenuBtnFormFile() {
        this.embedBtnList.addAll(MenuBtnScaner.getAllMenuBtns());
    }
    
    public boolean hasPermission(LoginUser user, String btnCode) {
        /**权限控制到按钮***/
        if (StrUtil.equals(getParamStr("PERMISSION_LEVEL"), "2")) {
            if (user.isSuperAdmin() || !existPermission(btnCode)) {
                return true;
            } else {
                return user.getPermissions()
                           .contains(btnCode);
            }
        } else {
            return true;
        }
    }
    
    
    /**
     * 刷新配置信息
     */
    public void refreshConfig() {
        try {
            this.syncConfig();
            this.afterConfig();
            this.sortConfigData();
        } catch (Exception e) {
            throw new FrameException(e.getMessage(), e);
        }
    }
    
    /**
     * 重新同步指定菜单编码下的按钮功能
     **/
    public void scanMenuBtnByMenuCode(String menuCode) {
        if (StrUtil.isNotEmpty(menuCode)) {
            List<BaseMenu> menuList = menuDao.selectList(null);
            for (EmbedMenuBtn btn : this.embedBtnList) {
                String btnmenuCode = StrUtil.subBefore(btn.getBtnCode(), ".", false);
                if (StrUtil.equals(menuCode, btnmenuCode)) {
                    saveMenuBtnToDb(menuList, btn);
                }
            }
        }
    }
    
    private boolean checkInited() {
//        try {
//            JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
//            String sql = "SELECT * from " + BASE_INFO + " WHERE " + KEY_COLUMN + " = '" + KEY_INITED + "'";
//            BaseInfo baseInfo = jdbcTemplate.queryForObject(sql, new BeanPropertyRowMapper<>(BaseInfo.class));
//            if (baseInfo != null) {
//                if (INITED_FLAG.equals(new String(baseInfo.getInfoValue()))) {
//                    return true;
//                }
//            }
            /*Table table = MetaUtil.getTableMeta(dataSource, BASE_INFO);
            if (!table.isEmpty()) {
                List<BaseInfo> infolist = DbUtil.use(dataSource).find(Entity.create(BASE_INFO).set(KEY_COLUMN, KEY_INITED), BaseInfo.class);
                if (!infolist.isEmpty()) {
                    BaseInfo inited = infolist.get(0);
                    if (INITED_FLAG.equals(new String(inited.getInfoValue()))) {
                        return true;
                    }
                }
            }*/
//        } catch (Exception e) {
//            return false;
//        }
        return true;
    }
    
    
    private void loadFrameModelFormXML() {
        List<URL> updatexmls = ResourceUtil.getResources(UPDATE_XML);
        for (URL url : updatexmls) {
            FrameModel framemodel = readModelFormXML(url);
            if (framemodel != null) {
                modelMap.put(framemodel.getModelCode(), framemodel);
            }
        }
    }
    
    
    public void syncModelVersion() {
        
        for (FrameExtConfig extConfig : extConfigList) {
            FrameModel model = modelMap.get(extConfig.modelCode());
            if (model != null && CollUtil.isNotEmpty(model.getVersions())) {
                model.setModeOrder(extConfig.order());
                versionMap.put(extConfig.modelCode(), model.getVersions());
            }
        }
        
        List<BaseVersion> updateversionList = new ArrayList<>();
        for (String modelkey : versionMap.keySet()) {
            List<Version> modelversion = versionMap.get(modelkey);
            FrameModel framemodel = modelMap.get(modelkey);
            if (CollUtil.isNotEmpty(modelversion)) {
                List<BaseVersion> dbmodelversions = versionDao.findByModelCode(modelkey);
                for (Version version : modelversion) {
                    BaseVersion dbversion = CollUtil.findOneByField(dbmodelversions, "versionNo", version.getVersionNo());
                    if (dbversion == null) {
                        BaseVersion newverion = new BaseVersion();
                        newverion.setModelCode(modelkey);
                        newverion.setVersionNo(version.getVersionNo());
                        newverion.setTitle(version.getTitle());
                        newverion.setScript(version.getScript());
                        newverion.setScriptUrl(getVersionScriptUrl(framemodel, version));
                        newverion.setDescription(version.getDescription());
                        newverion.setState(BaseVersion.VersionState.UN_EXECUTED);
                        newverion.setModelOrder(framemodel.getModeOrder());
                        updateversionList.add(newverion);
                    } else {
                        if (!StrUtil.equals(dbversion.getDescription(), version.getDescription()) || !StrUtil.equals(dbversion.getTitle(), version.getTitle()) || !StrUtil.equals(dbversion.getScript(), version.getScript())) {
                            dbversion.setDescription(version.getDescription());
                            dbversion.setTitle(version.getTitle());
                            dbversion.setScript(version.getScript());
                            dbversion.setScriptUrl(getVersionScriptUrl(framemodel, version));
                            updateversionList.add(dbversion);
                        }
                        
                    }
                }
            }
        }
		for (BaseVersion version : updateversionList) {
			if(version.getVersionId() == null){
				versionDao.insert(version);
			}else{
				versionDao.updateById(version);
			}
		}
    }
    
    
    private String getVersionScriptUrl(FrameModel model, Version version) {
        if (model == null || StrUtil.isEmpty(version.getScript())) {
            return null;
        }
        String urlstr = model.getBaseUrl() + "/META-INF/update/" + version.getVersionNo() + "/" + this.dbType + "/" + version.getScript();
        try {
            URL scriptUrl = new URL(urlstr);
            return scriptUrl.toString();
        } catch (MalformedURLException e) {
            log.error(model.getModelCode() + "[" + version.getVersionNo() + "]对应的脚本文件" + version.getScript() + "未找到,查找路径为:" + urlstr, e);
            return null;
        }
    }
    
    private FrameModel readModelFormXML(URL xmlurl) {
        try {
            String basePath = StrUtil.subBefore(xmlurl.toString(), "/META-INF", true);
            Document document = XmlUtil.readXML(xmlurl.openStream());
            Element root = XmlUtil.getRootElement(document);
            if ("FrameModel".equals(root.getTagName())) {
                FrameModel frameModel = new FrameModel();
                String modelCode = root.getAttribute("modelCode");
                boolean autoUpdate = Boolean.valueOf(root.getAttribute("autoUpdate"));
                Integer order = NumberUtil.parseInt(root.getAttribute("order"));
                frameModel.setModelCode(modelCode);
                frameModel.setAutoUpdate(autoUpdate);
                frameModel.setBaseUrl(basePath);
                frameModel.setModeOrder(order == null ? Integer.MAX_VALUE : order);
                Element versionsEL = XmlUtil.getElement(root, "versions");
                for (Element versionnode : XmlUtil.getElements(versionsEL, "version")) {
                    if (StrUtil.isNotEmpty(versionnode.getAttribute("versionNo"))) {
                        Version version = new Version();
                        version.setVersionNo(versionnode.getAttribute("versionNo"));
                        Element titlenode = XmlUtil.getElement(versionnode, "title");
                        version.setTitle(titlenode == null ? "" : titlenode.getTextContent());
                        Element scriptnode = XmlUtil.getElement(versionnode, "script");
                        version.setScript(scriptnode == null ? "" : scriptnode.getTextContent());
                        Element descriptionnode = XmlUtil.getElement(versionnode, "description");
                        version.setDescription(descriptionnode == null ? "" : descriptionnode.getTextContent());
                        frameModel.addVersion(version);
                    } else {
                        log.error("配置文件出现关键属性缺失:versions->version缺失属性versionNo,文件路径:" + xmlurl.getPath());
                    }
                }
                return frameModel;
            }
            return null;
        } catch (IOException e) {
            log.error("读取" + xmlurl.getPath() + "出错", e);
        }
        return null;
    }
    
    
    public void checkUpdateState() {
        int updatecount = versionDao.countByState(BaseVersion.VersionState.UN_EXECUTED);
        this.needUpdate = (updatecount > 0 ? true : false);
    }
    
    
    public void updateBackground() {
        if (this.needUpdate) {
            List<BaseVersion> dbversionList = new ArrayList<>();
            for (FrameModel frameModel : modelMap.values()) {
                if (frameModel.isAutoUpdate()) {
                    dbversionList.addAll(versionDao.findByModelCodeAndState(frameModel.getModelCode(), BaseVersion.VersionState.UN_EXECUTED));
                }
            }
            /**按照模块和版本号进行排序**/
            CollUtil.sort(dbversionList, Comparator.comparingInt(BaseVersion::getModelOrder)
                                                   .thenComparing((o1, o2) -> StrUtil.compareVersion(o1.getVersionNo(), o2.getVersionNo())));
            if (CollUtil.isNotEmpty(dbversionList)) {
                log.info("检测到需要自动更新的模块,开始自动更新");
                Connection connection = null;
                try {
                    connection = dataSource.getConnection();
                    connection.setAutoCommit(false);
                    for (BaseVersion version : dbversionList) {
                        log.info("开始更新版本:{}({}),更新脚本:{}", version.getModelCode(), version.getVersionNo(), version.getScript());
                        if (StrUtil.isNotEmpty(version.getScript())) {
                            URL scripturl = new URL(version.getScriptUrl());
                            log.info("发现更新脚本:{}", scripturl);
                            ScriptRunner sqlrunner = new ScriptRunner(connection);
                            sqlrunner.setAutoCommit(false);
                            sqlrunner.setStopOnError(true);
                            log.info("开始执行脚本:{}", scripturl);
                            sqlrunner.runScript(URLUtil.getReader(scripturl, Charset.forName("UTF-8")));
                            log.info("执行脚本完成:{}", scripturl);
                        }
                        version.setState(BaseVersion.VersionState.EXECUTED);
                        log.info("版本更新完成,更新版本状态");
                    }
                    log.info("所有版本全部更新完成,开始提交事务");
                    connection.commit();
                    connection.close();
					dbversionList.forEach(dbversion -> {
						if (dbversion.getVersionId() == null) {
							versionDao.insert(dbversion);
						} else {
							versionDao.updateById(dbversion);
						}
					});
                    log.info("本次更新全部完成");
                } catch (Exception e) {
                    log.error("自动更新版本出错,开始进行事务回滚", e);
                    if (connection != null) {
                        try {
                            connection.rollback();
                            connection.close();
                            log.error("事务已回滚,本次更新结束,更新结果:失败");
                        } catch (SQLException e1) {
                            log.error(e1.getMessage(), e1);
                        }
                    }
                }
                
            }
            checkUpdateState();
        }
    }
    
    
    public boolean isInited() {
        return inited;
    }
    
    public Map<String, InitParam> getInitParamsMap() {
        return initParamsMap;
    }
    
    /**
     * 获得分组并排序后的参数
     *
     * @return
     */
    public Map<String, List<InitParam>> getGroupedInitParams() {
        Map<String, List<InitParam>> groupmap = new LinkedHashMap<>();
        
        for (InitParam paramsBean : initParamsMap.values()) {
            if (groupmap.containsKey(paramsBean.getGroup())) {
                groupmap.get(paramsBean.getGroup())
                        .add(paramsBean);
            } else {
                groupmap.put(paramsBean.getGroup(), CollUtil.newLinkedList(paramsBean));
            }
        }
        return groupmap;
    }
    
    public List<InitSql> getInitSqlList() {
        return initSqlList;
    }
    
    public InitParam getParam(String key) {
        return this.initParamsMap.get(key);
    }
    
    public String getParamStr(String key) {
        return this.initParamsMap.get(key)
                                 .getStrValue();
    }
    
    public String getParamStr(CoreInitParams key) {
        return this.initParamsMap.get(key.name())
                                 .getStrValue();
    }
    
    public byte[] getParamByte(CoreInitParams key) {
        return this.initParamsMap.get(key.name())
                                 .getValue();
    }
    
    public byte[] getParamByte(String key) {
        return this.initParamsMap.get(key)
                                 .getValue();
    }
    
    /**
     * 获得数据库类型
     *
     * @return
     */
    public String getDbType() {
        return dbType;
    }
    
    /**
     * 获得系统初始化状态
     *
     * @param inited
     */
    public void setInited(boolean inited) {
        this.inited = inited;
    }
    
    public boolean isNeedUpdate() {
        return needUpdate;
    }
    
    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
    }
    
    public Map<String, List<Version>> getVersionMap() {
        return versionMap;
    }
    
    /**
     * 获得内置菜单列表
     *
     * @return
     */
    public List<EmbedMenu> getEmbedMenuList() {
        return embedMenuList;
    }
    
    /**
     * 获得内置字典列表
     *
     * @return
     */
    public List<EmbedDic> getEmbedDicList() {
        return CollUtil.newArrayList(embedDicMap.values());
    }
    
    /**
     * 获得内置主题列表
     *
     * @return
     */
    public List<EmbedTheme> getThemeList() {
        return themeList;
    }
    
    public Map<String, String> getShiroFilterChainMap() {
        return shiroFilterChainMap;
    }
    
    public Class getRealmClass() {
        return realmClass;
    }
    
    
    public Map<String, Filter> getShiroFilters() {
        return shiroFilters;
    }
    
    public String getShiroLoginUrl() {
        return shiroLoginUrl;
    }
    
    public List<EmbedNavMenu> getLeftNavList() {
        return leftNavList;
    }
    
    public List<EmbedNavMenu> getRightNavList() {
        return rightNavList;
    }
    
    public EmbedNavMenu getNavMenu(String navId) {
        return getNavMenu(this.navList, navId);
    }
    
    private EmbedNavMenu getNavMenu(List<EmbedNavMenu> navlist, String navId) {
        if (CollUtil.isNotEmpty(navlist)) {
            for (EmbedNavMenu nav : navlist) {
                if (StrUtil.equals(navId, nav.getId())) {
                    return nav;
                }
                
                EmbedNavMenu subresult = getNavMenu(nav.getChildren(), navId);
                if (subresult != null) {
                    return subresult;
                }
            }
        }
        return null;
    }
    
    public boolean existMenuBtn(String btnCode) {
        EmbedMenuBtn btn = CollUtil.findOneByField(this.embedBtnList, "btnCode", btnCode);
        if (btn != null) {
            return true;
        } else {
            return false;
        }
    }
    
    public List<String> getIndexJsList() {
        return indexJsList;
    }
    
    //获取bean
    public <T> T getBean(Class<T> requiredType) {
        return this.configurableContext.getBean(requiredType);
    }

    public Map<String, Class> getBeetlTagMap() {
        return beetlTagMap;
    }

    public void setBeetlTagMap(Map<String, Class> beetlTagMap) {
        this.beetlTagMap = beetlTagMap;
    }

    public List<Class> getRealmClassList() {
        return realmClassList;
    }

    public void setRealmClassList(List<Class> realmClassList) {
        this.realmClassList = realmClassList;
    }
}
