package com.kdgcsoft.scrdc.frame.webframe.core.controller;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.kdgcsoft.scrdc.frame.webframe.core.cache.CacheHelper;
import com.kdgcsoft.scrdc.frame.webframe.core.cnst.FrameConst;
import com.kdgcsoft.scrdc.frame.webframe.core.model.GridPage;
import com.kdgcsoft.scrdc.frame.webframe.core.model.GridPageRequest;
import com.kdgcsoft.scrdc.frame.webframe.core.model.JsonResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author liu.changming
 * @version 1.0 2019/9/16
 */
@Controller
@RequestMapping("/core/cache-monitor")
public class CacheMonitorController extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(CacheMonitorController.class);
    @Autowired(required = false)
    private CacheManager cacheManager;

    @RequestMapping("/index")
    @ResponseBody
    public ModelAndView index() {
        return renderView("/core/cacheMonitor.html");
    }

/*    @RequestMapping("/list")
    @ResponseBody
    public JsonResult getTestCache() {
        Map<String, Map> result = new HashMap<>();
        List<String> cacheNames = new ArrayList<>(cacheManager.getCacheNames());
        Collections.sort(cacheNames);
        cacheNames.forEach(key -> {
            if (cacheManager instanceof FlexibleCaffeineCacheManager) {
                Cache cache = cacheManager.getCache(key);
                com.github.benmanes.caffeine.cache.Cache nativeCache = (com.github.benmanes.caffeine.cache.Cache) cache.getNativeCache();
                ConcurrentMap concurrentMap = nativeCache.asMap();
                result.put(key, concurrentMap);
            } else if (cacheManager instanceof EhCacheCacheManager) {
                Ehcache ehcache = (Ehcache) cacheManager.getCache(key).getNativeCache();
                List keys = ehcache.getKeys();
                Map<String, Object> cacheMap = new HashMap<>();
                for (Object k : keys) {
                    Element element = ehcache.get(k);
                    if (element != null) {
                        Object objectValue = element.getObjectValue();
                        cacheMap.put(k.toString(), objectValue);
                    }
                }
                result.put(key, cacheMap);
            } else if (cacheManager instanceof JCacheCacheManager) {
                javax.cache.Cache cache = (javax.cache.Cache) cacheManager.getCache(key).getNativeCache();
                logger.error("unexpected cacheManager!");
            } else if (cacheManager instanceof RedisCacheManager) {
                logger.error("unexpected cacheManager!");
            }
        });
        return JsonResult.success(result);
    }*/

    @RequestMapping("/names")
    @ResponseBody
    public GridPage getCacheNames(GridPageRequest request) {
        List<String> cacheNames = new ArrayList<>(cacheManager.getCacheNames());
        Collections.sort(cacheNames);
        List<Map<String, String>> cacheNamesList = cacheNames.stream().map(s -> {
            Map<String, String> map = new HashMap<>();
            map.put("name", s);
            return map;
        }).collect(Collectors.toList());
        int from = (request.getPage() - 1) * request.getRows();
        int end = Math.min(from + request.getRows(), 1000);
        if (end > cacheNames.size()) {
            end = cacheNames.size();
        }
        GridPage gridPage = new GridPage();
        gridPage.setTotal(Math.min(cacheNames.size(), 1000));
        if (from > cacheNames.size()) {
            gridPage.setRows(Collections.emptyList());
        } else {
            gridPage.setRows(cacheNamesList.subList(from, end));
        }
        return gridPage;
    }

    @RequestMapping("/keys")
    @ResponseBody
    public GridPage getCacheKeys(GridPageRequest request, String cacheName) {
        List<String> keys = CacheHelper.getCacheKeys(cacheManager, cacheName);
        Collections.sort(keys);
        List<Map<String, String>> keysList = keys.stream().map(s -> {
            Map<String, String> map = new HashMap<>();
            map.put("name", s);
            return map;
        }).collect(Collectors.toList());
        int from = (request.getPage() - 1) * request.getPage();
        int end = Math.min(from + request.getRows(), 1000);
        if (end > keysList.size()) {
            end = keysList.size();
        }
        GridPage gridPage = new GridPage();
        gridPage.setTotal(Math.min(keysList.size(), 1000));
        if (from > keysList.size()) {
            gridPage.setRows(Collections.emptyList());
        } else {
            gridPage.setRows(keysList.subList(from, end));
        }
        return gridPage;
    }

    @RequestMapping("/content")
    @ResponseBody
    public JsonResult getCacheContent(String cacheName, String key) {
        Cache cache = cacheManager.getCache(cacheName);
        try {
            return JsonResult.success(FrameConst.MSG_DEFAULT_SUCCESS, JSON.toJSONString(cache.get(key).get(), true));
        } catch (Exception e) {
            logger.error(String.format("getCacheContent error,cacheName: %s,key: %s", cacheName, key), e);
            return JsonResult.error("获取缓存内容出错");
        }
    }

    @RequestMapping("/clear")
    @ResponseBody
    public JsonResult clearCache(String cacheName, String key) {
        try {
            Cache cache = cacheManager.getCache(cacheName);
            if (StrUtil.isEmpty(key)) {
                cache.clear();
            } else {
                cache.evict(key);
            }
            return JsonResult.success();
        } catch (Exception e) {
            logger.error(String.format("clearCache error,cacheName: %s,key: %s", cacheName, key), e);
            return JsonResult.error("清除缓存失败！请刷新缓存列表！");
        }
    }

    @RequestMapping("/check")
    @ResponseBody
    public JsonResult checkCache() {
        if (CacheHelper.checkCacheManager(cacheManager)) {
            return JsonResult.success();
        } else {
            return JsonResult.error();
        }
    }

    @RequestMapping("/search-key")
    @ResponseBody
    public JsonResult searchKey(String cacheName, String key) {
        Cache cache = cacheManager.getCache(cacheName);
        try {
            cache.get(key).get();
            return JsonResult.success();
        } catch (Exception e) {
            logger.error(String.format("searchKey error,cacheName: %s,key: %s", cacheName, key), e);
            return JsonResult.error("键名:" + key + "不存在");
        }
    }
}
