package com.kdgcsoft.jt.xzzf.dubbo.znqz.highSpeedInfo.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.znqz.highSpeedInfo.entity.GsgljkVO;
import com.kdgcsoft.jt.xzzf.dubbo.znqz.highSpeedInfo.entity.GsglmjVO;
import com.kdgcsoft.jt.xzzf.dubbo.znqz.highSpeedInfo.entity.GsglsjVO;

/**
 * @Description: 高速公路接口
 * @Author: zd
 * @Date: 2022/5/12
 */
public interface GsglService {

    /**
     * 高速公路门架信息分页查询
     *
     * @param current
     * @param size
     * @param gsglmjVO
     * @return
     */
    Page<GsglmjVO> gsglMjxxPage(long current, long size, GsglmjVO gsglmjVO);

    /**
     * 新增高速公路门架信息
     *
     * @param gsglmjVO
     * @return
     */
    boolean addGsglMjxx(GsglmjVO gsglmjVO);

    /**
     * 修改高速公路门架信息
     *
     * @param gsglmjVO
     * @return
     */
    boolean updateGsglMjxx(GsglmjVO gsglmjVO);

    /**
     * 删除高速公路门架信息
     *
     * @param ids
     * @return
     */
    boolean deleteGsglMjxx(String ids);

    /**
     * 从门架信息表同步到ZNQZ_J_GSGLMJGX
     *
     * @param id
     * @return
     */
    boolean syncGsglMjxx(String id);

    /**
     * 高速公路交汇口分页查询
     *
     * @param current
     * @param size
     * @param gsgljkVO
     * @return
     */
    Page<GsgljkVO> gsgljkPage(long current, long size, GsgljkVO gsgljkVO);

    /**
     * 新增高速公路交汇口
     *
     * @param gsgljkVO
     * @return
     */
    boolean addGsgljk(GsgljkVO gsgljkVO);

    /**
     * 修改高速公路交汇口
     *
     * @param gsgljkVO
     * @return
     */
    boolean updateGsgljk(GsgljkVO gsgljkVO);

    /**
     * 删除高速公路交汇口
     *
     * @param ids
     * @return
     */
    boolean deleteGsgljk(String ids);

    /**
     * 高速公路与省界交汇口分页查询
     *
     * @param current
     * @param size
     * @param gsglsjVO
     * @return
     */
    Page<GsglsjVO> gsglsjjkPage(long current, long size, GsglsjVO gsglsjVO);

    /**
     * 新增高速公路与省界交汇口
     *
     * @param gsglsjVO
     * @return
     */
    boolean addGsglsjjk(GsglsjVO gsglsjVO);

    /**
     * 修改高速公路与省界交汇口
     *
     * @param gsglsjVO
     * @return
     */
    boolean updateGsglsjjk(GsglsjVO gsglsjVO);

    /**
     * 删除高速公路与省界交汇口
     *
     * @param ids
     * @return
     */
    boolean deleteGsglsjjk(String ids);
}
