package com.kdgcsoft.jt.xzzf.dubbo.znqz.highSpeedInfo.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 收费站车辆通行图片实体类
 * @Author: zd
 * @Date: 2022/2/24
 */
@Data
@TableName("ZNQZ_J_SFZCLTXTP")
public class SfzcltxtpVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 图片ID
     */
    @TableId
    private String tpid;

    /**
     * 通行记录ID
     */
    private String txjlid;

    /**
     * 图片名称
     */
    private String tpmc;

    /**
     * 图片路径
     */
    private String tplj;

    /**
     * 拍摄时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date pssj;

    /**
     * 图片来源
     */
    private String tply;

}
