package com.kdgcsoft.jt.xzzf.dubbo.znqz.highSpeedInfo.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 高速车辆通行信息实体类
 * @Author: zd
 * @Date: 2022/2/23
 */
@Data
@TableName("ZNQZ_J_GSCLTXXX")
public class GscltxxxVO implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 通行信息ID
     */
    @TableId
    private String xxid;

    /**
     * 收费站ID
     */
    private String sfzid;

    /**
     * 车身颜色
     */
    private String csys;

    /**
     * 车牌颜色
     */
    private String cpys;

    /**
     * 车牌号
     */
    private String cph;

    /**
     * 车辆类型编码
     */
    private String cllxbm;

    /**
     * 车辆类型
     */
    private String czlxbm;

    /**
     * 出入口类型
     */
    private String cklx;

    /**
     * 通行区间
     */
    private String txqj;

    /**
     * 通行时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
//    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date txsj;

    /**
     * 图片ID
     */
    @TableField(exist = false)
    private String tpid;

    /**
     * 图片名称
     */
    @TableField(exist = false)
    private String tpmc;

    /**
     * 图片路径
     */
    @TableField(exist = false)
    private String tplj;

    /**
     * 拍摄时间
     */
    @TableField(exist = false)
    private String pssjStr;

    /**
     * 图片来源
     */
    @TableField(exist = false)
    private String tply;

    /**
     * 收费站名称
     */
    @TableField(exist = false)
    private String sfzmc;

    /**
     * 通行时间Str
     */
    @TableField(exist = false)
    private String txsjStr;

    /**
     * 通行时间起
     */
    @TableField(exist = false)
    private String txsjQi;

    /**
     * 通行时间止
     */
    @TableField(exist = false)
    private String txsjZhi;

    /**
     * 龙门架名称
     */
    @TableField(exist = false)
    private String lmjmc;

//    @Override
//    public String getId() {
//        return xxid;
//    }
//
//    @Override
//    public void setId(String id) {
//        this.xxid = id;
//    }

}
