package com.kdgcsoft.jt.xzzf.dubbo.znqz.ffyyyj.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @Description: 未随车携带包车客运标志
 * @Author: zd
 * @Date: 2022/2/25
 */
@Data
@TableName("ZNQZ_J_WXDBCKYBS")
public class WxdbckybsVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId
    private String id;

    /**
     * 车牌号码
     */
    private String cphm;

    /**
     * 车牌颜色
     */
    private String cpys;

    /**
     * 车辆类型
     */
    private String cllxbm;

    /**
     * 经验范围
     */
    private String jyfw;

    /**
     * 车牌型号
     */
    private String cpxh;

    /**
     * 预警时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date yjsj;

    /**
     * 预警时间起
     */
    @TableField(exist = false)
    private String yjsjQi;

    /**
     * 预警时间止
     */
    @TableField(exist = false)
    private String yjsjZhi;


    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}
