package com.kdgcsoft.jt.xzzf.dubbo.zhdd.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.zhdd.model.entity.InstructEntity;





public interface InstructAppService {

    /**
     * 指令待办
     *
     * @param receiverId 当前app登录人id
     * @param zldb       指令待办的状态
     * @param page       页数
     * @param limit      条数
     * @return
     */
    Page<InstructEntity> findzldbById(String receiverId, String zldb, long page, long limit);


    /**
     * 指令以办
     *
     * @param receiverId 当前app登录人id
     * @param zlyb       指令以办的状态
     * @param page       页数
     * @param limit      条数
     * @return
     */
    Page<InstructEntity> findzlybById(String receiverId, String zlyb, long page, long limit);


    /**
     * 指令反馈添加
     *
     * @param receiverId 接收人id
     * @param instructId 指令id
     * @param fkContent  反馈内容
     * @param fileName   附件名称
     * @param filePath   附件路径
     */
    void zlfkAdd(String receiverId, String instructId, String fkContent, String[] fileName, String[] filePath);

}
