package com.kdgcsoft.jt.xzzf.dubbo.zhdd.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zhdd.model.vo.BjjySearchVo;
import com.kdgcsoft.jt.xzzf.dubbo.zhdd.model.vo.BjjyTypeVo;


import java.util.List;

/**
 * @author yangqianhai
 * @version 1.0
 * @date 2020/7/7 19:05
 * 报警增援APP相关service层
 */
public interface BjjyAppService {

    /**
     * 报警增援列表接口
     *
     * @return
     */
    List<BjjyTypeVo> getBjjyType();

    /**
     * 保存报警增援信息
     *
     * @param rescueType 请求类型
     * @param sysUser    请求人
     * @param longitude  经度
     * @param latitude   纬度
     * @param position   位置
     */
    void saveBjjyInfo(String rescueType, SysUser sysUser, String longitude, String latitude, String position);


    /**
     * 我的报警增援记录查询
     *
     * @param rescueUserId 请求人id
     * @param page         页数
     * @param limit        条数
     * @return
     */
    Page<BjjySearchVo> getMyBjjyInfo(String rescueUserId, long page, long limit);
}
