package com.kdgcsoft.jt.xzzf.dubbo.zhdd.model.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

@Data
public class BjjySearchVo  extends BaseEntity<String> {
    private static final long serialVersionUID = 1L;
    /**
     * 报警救援表 ID
     */
    public String rescueId;

    /**
     * '报警类型 01 报警 02 救援  类型存数字字典 不要写死';
     */
    private String rescueType;

    /**
     * 报警类型对应的名称 01 ---> 报警  02 ----> 救援
     */
    private String rescueName;

    /**
     * 报警时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date rescueTime;

    /**
     * 报警时间Str类型
     */
    private String rescueTimeStr;

    /**
     * 报警救援 人id
     */
    private String rescueUser;

    /**
     * 经度
     */
    private String longitude;

    /**
     * 纬度
     */
    private String latitude;

    /**
     * 位置
     */
    private String position;

    /**
     * 处理结果  0-未处理 1-已处理
     */
    private String handleResult;

    /**
     * 处理结果值  0-未处理 1-已处理
     */
    private String handleResultText;

    /**
     * 处理人
     */
    private String handleUser;

    /**
     * 处理时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date handleTime;

    /**
     * 处理时间 字符串str
     */
    private String handleTimeStr;

    /**
     * 处理过程
     */
    private String handleProcess;

    /**
     * 是否报警弹过 弹过 0  没弹过 1
     */
    private String upStatus;

    /**
     * 请求人姓名
     */
    private String rescueUserName;

    /**
     * 报警救援 人 orgId
     */
    private String rescueUserOrgId;

    /**
     * 报警救援 人 orgName
     */
    private String rescueUserOrgName;

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void setId(String id) {

    }
}
