package com.kdgcsoft.jt.xzzf.dubbo.zhdd.model.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.scrdc.frame.webframe.core.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;


@Data
public class ZxxdEntity extends BaseEntity {

    /**
     * 专项行动ID
     */
    private String zxxdId;


    /**
     * 专项行动编号
     */
    private String zxxdNumber;


    /**
     * 行动名称
     */
    private String zxxdName;


    /**
     *机构分类
     */
    private String organType;

    /**
     * 主题分类
     */
    private int themeType;

    /**
     * 行业分类
     */
    private int tradeType;

    /**
     *机构分类文字
     */
    @TableField(exist = false)
    private String jgfl;

    /**
     * 主题分类文字
     */
    @TableField(exist = false)
    private String ztfl;

    /**
     * 行业分类文字
     */
    @TableField(exist = false)
    private String hyfl;

    /**
     * 发布时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date pubTime;

    /**
     * 发布时间字符串
     */
    private String pubTimeString;


    /**
     * 主题内容
     */
    private String zxxdContent;

    /**
     * 发布单位
     */
    private String pubUnit;

    /**
     * 相关附件路径
     */
    private String filePath;


    /**
     *相关附件路径名称
     */
    private String fileName;

    /**
     * 备注
     */
    private String remarks;

    /**
     * 发布状态 0 未发布  1已发布
     */
    private int zxxdStatus;

    /**
     * 所属机构Id
     */
    private String orgId;

    /**
     * 逻辑删除
     */
    private String delStatus;

    /**
     * 专项行动填报状态
     */
    private String zxxdtbzt;


    /**
     * 主键id
     */
    private String cszjId;

    /**
     * 附件list
     */
    private List<FjEntity> fjList;

    /**
     * 发布单位名称
     */
    private String pubUnitName;

}
