package com.kdgcsoft.jt.xzzf.dubbo.zhdd.model.entity;


import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.scrdc.frame.webframe.core.entity.BaseEntity;
import lombok.Data;

import java.util.Date;
import java.util.List;

@Data
@TableName
public class InstructEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 指令id
     */
    private String instructId;

    /**
     * 指令回复id
     */
    private String instructReplyId;

    /**
     * 指令标题
     */
    private String instructTitle;


    /**
     * 指令内容
     */
    private String instructContent;


    /**
     * 指令发布时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime;


    /**
     * 指令发送人
     */
    private String sendName;

    /**
     * 指令发送人电话
     */
    private String tel;

    /**
     * 指令状态
     */
    private String instructStatus;


    /**
     * 相关附件路径
     */
    private String filePath;

    /**
     * 附件名称
     */
    private String fileName;

    /**
     * 指令发送人单位
     */
    private String instructOrg;


    /**
     * 发送人员的组织机构id
     */
    private String orgId;



    /**
     * 指令回复时间
     */
    private String replyTime;


    /**
     * 指令回复id
     */
    private String replyId;


    /**
     * 附件list
     */
    private List<FjEntity> fjList;
}
