package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfzj.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfzjZjnsxxVo
 * @author chris
 * @description 执法证件年审信息实体类
 * @version 1.0
 * @date 2021-03-30 19:22
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFZJGL_J_ZJNSXX")
public class ZfzjZjnsxxVo extends BaseEntity<String> {

    /******
     * 证件年审信息Id
     */
    @TableId
    @TableField("ZJNSXX_ID")
    private String zjnsxxId;

    /******
     * 执法证件信息Id
     */
    @TableField("ZFZJXX_ID")
    private String zfzjxxId;

    /******
     * 执法人员姓名
     */
    @TableField("XM")
    private String xm;

    /******
     * 执法人员年龄
     */
    @TableField("NL")
    private String nl;

    /******
     * 执法证号
     */
    @TableField("ZFZH")
    private String zfzh;

    /******
     * 组织机构Id
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /******
     * 执法机构名称
     */
    @TableField("ZFJGMC")
    private String zfjgmc;

    /******
     * 执法门类名称
     */
    @TableField("ZFMLMC")
    private String zfmlmc;

    /******
     * 职务名称
     */
    @TableField("ZWMC")
    private String zwmc;

    /******
     * 学历名称
     */
    @TableField("XLMC")
    private String xlmc;

    /******
     * 是否新增执法人员
     */
    @TableField("SFXZZFRY")
    private String sfxzzfry;

    /******
     * 是否一线执法
     */
    @TableField("SFYXZF")
    private String sfyxzf;

    /******
     * 执法证件管理情况
     */
    @TableField("ZFZJGLQK")
    private String zfzjglqk;

    /******
     * 执法或人事考核情况
     */
    @TableField("ZFHRSKHQK")
    private String zfhrskhqk;

    /******
     * 培训抽考情况
     */
    @TableField("PXCKQK")
    private String pxckqk;

    /******
     * 执法过失违纪情况
     */
    @TableField("ZFGSWJQK")
    private String zfgswjqk;

    /******
     * 奖惩情况
     */
    @TableField("JCQK")
    private String jcqk;

    /******
     * 审验结果代码
     */
    @TableField("SYJGDM")
    private String syjgdm;

    /******
     * 审验结果名称
     */
    @TableField("SYJGMC")
    private String syjgmc;

    /******
     * 年审年度
     */
    @TableField("NSND")
    private String nsnd;

    /******
     * 年审日期
     */
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    @TableField("NSRQ")
    private Date nsrq;

    /******
     * 上报备案日期
     */
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    @TableField("SBBARQ")
    private Date sbbarq;

    /******
     * 说明
     */
    @TableField("SM")
    private Date sm;

    /******
     * 状态
     */
    @TableField("ZT")
    private String zt;

    /******
     * 是否新增执法人员Text
     */
    @TableField(exist = false)
    private String sfxzzfryText;

    /******
     * 是否一线执法Text
     */
    @TableField(exist = false)
    private String sfyxzfText;

    /******
     * 状态Text
     */
    @TableField(exist = false)
    private String ztText;

    @Override
    public String getId() {
        return zjnsxxId;
    }

    @Override
    public void setId(String id) {
        this.zjnsxxId = id;
    }
}
