package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfzj.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfzjZfzjxxVo
 * @author chris
 * @description 执法证件的证件信息实体类
 * @version 1.0
 * @date 2021-03-30 19:21
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFZJGL_J_ZFZJXX")
public class ZfzjZfzjxxVo extends BaseEntity<String> {

    /******
     * 执法证件信息Id
     */
    @TableId
    @TableField("ZFZJXX_ID")
    private String zfzjxxId;

    /******
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /******
     * 证件状态代码
     */
    @TableField("ZJZTDM")
    private String zjztdm;

    /******
     * 实卡归属代码
     */
    @TableField("SKGSDM")
    private String skgsdm;

    /******
     * 执法人员姓名
     */
    @TableField("XM")
    private String xm;

    /******
     * 执法门类代码
     */
    @TableField("ZFMLDM")
    private String zfmldm;

    /******
     * 执法证号
     */
    @TableField("ZFZH")
    private String zfzh;

    /******
     * 岗位代码
     */
    @TableField("GWDM")
    private String gwdm;

    /******
     * 执法区域
     */
    @TableField("ZFQY")
    private String zfqy;

    /******
     * 组织机构Id
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /******
     * 执法机构名称
     */
    @TableField("ZFJGMC")
    private String zfjgmc;

    /******
     * 卡物理编号
     */
    @TableField("KWLBH")
    private String kwlbh;

    /******
     * 发证日期
     */
    @TableField("FZRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date fzrq;

    /******
     * 起始有效期
     */
    @TableField("YXQQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date yxqq;

    /******
     * 截止有效期
     */
    @TableField("YXQZ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date yxqz;

    /******
     * 发证人
     */
    @TableField("FZR")
    private String fzr;

    /******
     * 发证机构
     */
    @TableField("FZJG")
    private String fzjg;

    /******
     * 变化原因
     */
    @TableField("BHYY")
    private String bhyy;

    /******
     * 变化时间
     */
    @TableField("BHSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date bhsj;

    /******
     * 责任信息Id
     */
    @TableField("ZRXX_ID")
    private String zrxxId;

    /******
     * 证件状态代码Text
     */
    @TableField(exist = false)
    private String zjztdmText;

    /******
     * 实卡归属代码Text
     */
    @TableField(exist = false)
    private String skgsdmText;

    /******
     * 执法门类代码Text
     */
    @TableField(exist = false)
    private String zfmldmText;

    /******
     * 岗位代码Text
     */
    @TableField(exist = false)
    private String gwdmText;

    @Override
    public String getId() {
        return zfzjxxId;
    }

    @Override
    public void setId(String id) {
        this.zfzjxxId = id;
    }
}
