package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfzj.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfzjZfhxxVo
 * @author chris
 * @description 执法证件执法号信息实体类
 * @version 1.0
 * @date 2021-03-30 19:21
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFZJGL_J_ZFHXX")
public class ZfzjZfhxxVo extends BaseEntity<String> {

    /******
     * 执法号信息Id
     */
    @TableId
    @TableField("ZFHXX_ID")
    private String zfhxxId;

    /******
     * 执法号段信息Id
     */
    @TableField("ZFHDXX_ID")
    private String zfhdxxId;

    /******
     * 执法证号
     */
    @TableField("ZFZH")
    private String zfzh;

    /******
     * 使用状态
     */
    @TableField("SYZT")
    private String syzt;

    /******
     * 分配时间
     */
    @TableField("FPSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date fpsj;

    /******
     * 锁定时间
     */
    @TableField("SDSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date sdsj;

    /******
     * 待解锁时间
     */
    @TableField("DJSSJ")
    private String djssj;

    /******
     * 解锁时间
     */
    @TableField("JSSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date jssj;

    /******
     * 使用状态Text
     */
    @TableField(exist = false)
    private String syztText;

    @Override
    public String getId() {
        return zfhxxId;
    }

    @Override
    public void setId(String id) {
        this.zfhxxId = id;
    }
}
