package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity.ZfryRyxxVo;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfzj.entity.ZfzjZfzjxxVo;

import java.util.List;

/****
 * @className ZfryRyxxService
 * @author chris
 * @description
 * @version 1.0
 * @date 2021-03-30 20:45
 */
public interface ZfryRyxxService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param curUserOrgId 当前登录用户组织机构Id
     * @param entity 人员信息实体类
     * @return
     */
    Page<ZfryRyxxVo> pageData(Page<ZfryRyxxVo> page, String curUserOrgId, ZfryRyxxVo entity);

    /*******
     * 获取执法人员信息
     * @param filter 关键字
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    ZfryRyxxVo getEntityInfoByFilterAndOrgId(String filter, String curUserOrgId);

    /******
     * 保存信息
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param curUser 当前登录用户
     */
    void saveOrUpdate(ZfryRyxxVo entity, boolean isCreate, SysUser curUser);

    /******
     * 获取执法人员信息
     * @param filter 关键字过滤
     * @param orgId 组织机构Id
     * @param curUserOrgId 当前登录用户所属组织机构
     * @return
     */
    List<ComboboxVo> queryEntityInfoCombobox(String filter, String orgId, String curUserOrgId);

    /*****
     * 获取所有的执法人员信息
     * @return
     */
    List<ZfryRyxxVo> queryAllZfryInfo();

    /******
     * 获取执法人员信息
     * @param zfryId 执法人员Id
     * @return
     */
    ZfryRyxxVo getEntityInfoByZfryId(String zfryId);

    /******
     * 获取执法人员信息
     * @param idCard 执法人员身份证号
     * @return
     */
    ZfryRyxxVo getEntityInfoByIdCard(String idCard);

    /******
     * 获取执法人员信息
     * @param zfzh 执法证号
     * @return
     */
    ZfryRyxxVo getEntityInfoByZfzh(String zfzh);

    /******
     * 修改执法证号信息
     * @param entity 执法证件信息
     * @param curUser 当前登录用户
     */
    void modifyZfzh(ZfzjZfzjxxVo entity, SysUser curUser);

    /*****
     * 导入新进执法人员信息
     * @param dataList 新进执法人员信息列表
     * @param tempTitleList 模板表头信息
     * @param curUser 当前登录用户
     * @return
     */
    ExcelRowInfo importXjRyInfo(List<ZfryRyxxVo> dataList, List<String> tempTitleList, SysUser curUser);

    /*****
     * 导入新进执法人员信息
     * @param dataList 新进执法人员信息列表
     * @param curUser 当前登录用户
     * @return
     */
    ExcelRowInfo importYrzRyInfo(List<ZfryRyxxVo> dataList, SysUser curUser);

    /******
     * 校正用户信息通过执法人员Id
     * @param userId 用户Id
     * @param zfryId 执法人员Id
     * @param curUser 当前登录用户
     */
    void rectifyZfryInfoByUserId(String userId, String zfryId, SysUser curUser);

    /******
     * 重置执法人员信息
     * @param ids 执法人员Id集合
     * @param curUser 当前登录用户
     */
    void resetGxzt(String ids, SysUser curUser);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param zfryIds 执法人员主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<ZfryRyxxVo> export(ZfryRyxxVo entity, String zfryIds, String curUserOrgId);

    /*****
     * 删除执法人员信息
     * @param ids 　主键Id
     * @param user
     * @return
     */
    void deleteDataByIds(String ids, SysUser user);


}
