package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity.ZfryKhxmVo;

import java.util.List;

/****
 * @className ZfryKhxmService
 * @author chris
 * @description 执法人员考核项目服务层接口
 * @version 1.0
 * @date 2021-03-25 16:32
 */
public interface ZfryKhxmService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param curUserOrgId 当前登录用户组织机构Id
     * @param entity 考核项目实体类
     * @return
     */
    Page<ZfryKhxmVo> pageData(Page<ZfryKhxmVo> page, String curUserOrgId, ZfryKhxmVo entity);

    /******
     * 保存或修改考核项目相关信息
     * @param entity 考核项目实体类
     * @param isCreate 是否新增
     * @param curUser 当前登录用户
     */
    void saveOrUpdate(ZfryKhxmVo entity, boolean isCreate, SysUser curUser);

    /*****
     * 获取执法人员考核项目信息
     * @param id 主键ID
     * @return
     */
    ZfryKhxmVo getEntityInfoById(String id);

    /*****
     * 删除执法人员考核项目信息
     * @param ids id集合
     * @param curUser 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser curUser);

    /*****
     * 修改执法人员考核项目状态
     * @param ids id集合
     * @param curUser 当前登录用户
     */
    void modifyDataStatusByIds(String ids, SysUser curUser);

    /******
     * 考核标题下拉数据
     * @param filter
     * @return
     */
    List<ComboboxVo> queryKhxmbtInfoCombobox(String filter);

    /******
     * 上级考核项目下拉数据
     * @param filter
     * @return
     */
    List<ComboboxVo> querySjkhxmInfoCombobox(String filter);
}
