package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxCascaderVo;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxGroupVo;
import com.kdgcsoft.jt.xzzf.common.component.TreeDataVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity.ZfryGwdjdmVo;

import java.util.List;

/****
 * @className ZfryGwdjdmService
 * @author chris
 * @description
 * @version 1.0
 * @date 2021-03-30 20:43
 */
public interface ZfryGwdjdmService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<ZfryGwdjdmVo> pageData(Page<ZfryGwdjdmVo> page, ZfryGwdjdmVo entity);

    /*****
     * 获取岗位等级信息
     * @param id Id
     * @return
     */
    ZfryGwdjdmVo getEntityInfoById(String id);

    /*****
     * 保存系统数据
     * @param entity
     * @param isCreate 是否创建
     * @param curUser 当前登录用户
     */
    void saveOrUpdate(ZfryGwdjdmVo entity, boolean isCreate, SysUser curUser);

    /******
     * 删除信息
     * @param ids
     * @param curUser 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser curUser);

    /*******
     * 获取下一个序号
     * @param pId 父级Id
     * @return
     */
    Integer getEntityInfoNextOrderNo(String pId);

    /****
     * 获取岗位等级树数据
     * @param id id
     * @param filter 关键字过滤
     * @return
     */
    List<TreeDataVo> queryGwdjTreeData(String id, String filter);

    /*****
     * 查询下拉框的键值对
     * @param filter 关键字过滤
     * @return
     */
    List<ComboboxGroupVo> queryEntityInfoGroupCombobox(String filter);

    /*****
     * 查询级联下拉框的键值对
     * @param filter 关键字过滤
     * @return
     */
    List<ComboboxCascaderVo> queryEntityInfoCascaderCombobox(String filter);
}
