package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfryZrxxVo
 * @author chris
 * @description 执法人员责任信息实体类
 * @version 1.0
 * @date 2021-03-30 19:16
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_ZRXX")
public class ZfryZrxxVo extends BaseEntity<String> {

    /******
     * 责任信息Id
     */
    @TableId
    @TableField("ZRXX_ID")
    private String zrxxId;

    /******
     * 登记单位Id
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /******
     * 登记单位名称
     */
    @TableField("DJDWMC")
    private String djdwmc;

    /******
     * 责任事故名称
     */
    @TableField("ZRSGMC")
    private String zrsgmc;

    /******
     * 发生时间
     */
    @TableField("FSSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date fssj;

    /******
     * 事故地点
     */
    @TableField("SGDD")
    private String sgdd;

    /******
     * 责任人
     */
    @TableField("ZRR")
    private String zrr;

    /******
     * 描述
     */
    @TableField("MS")
    private String ms;

    /******
     * 追究意见
     */
    @TableField("ZJYJ")
    private String zjyj;

    /******
     * 执法责任分类代码
     */
    @TableField("ZFZRFLDM")
    private String zfzrfldm;

    /******
     * 执法责任分类代码Text
     */
    @TableField(exist = false)
    private String zfzrfldmText;


    @Override
    public String getId() {
        return zrxxId;
    }

    @Override
    public void setId(String id) {
        this.zrxxId = id;
    }
}
