package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/****
 * @className ZfryRyxxVo
 * @author chris
 * @description 执法人员人员信息实体类
 * @version 1.0
 * @date 2021-03-30 18:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_ZFRYXX")
public class ZfryRyxxVo extends BaseEntity<String> {

    /******
     * 执法人员信息Id
     */
    @TableId
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /******
     * 学历代码
     */
    @TableField("XLDM")
    private String xldm;

    /******
     * 政治面貌代码
     */
    @TableField("ZZMMDM")
    private String zzmmdm;

    /******
     * 组织机构Id
     */
    @TableField("ZZJGID")
    private String zzjgid;

    /******
     * 职务代码
     */
    @TableField("ZWDM")
    private String zwdm;

    /******
     * 执法门类代码
     */
    @TableField("ZFMLDM")
    private String zfmldm;

    /******
     * 人员编制代码
     */
    @TableField("RYBZDM")
    private String rybzdm;

    /******
     * 职务级别代码
     */
    @TableField("ZWJBDM")
    private String zwjbdm;

    /******
     * 任职状态代码
     */
    @TableField("RZZTDM")
    private String rzztdm;

    /******
     * 执法人员类型代码
     */
    @TableField("ZFRYLXDM")
    private String zfrylxdm;

    /******
     * 民族代码
     */
    @TableField("MZDM")
    private String mzdm;

    /******
     * 执法人员性质代码
     */
    @TableField("ZFRYXZDM")
    private String zfryxzdm;

    /******
     * 人员审批状态代码
     */
    @TableField("RYSPZTDM")
    private String ryspztdm;

    /******
     * 证件状态代码
     */
    @TableField("ZJZTDM")
    private String zjztdm;

    /******
     * 性别代码
     */
    @TableField("XBDM")
    private String xbdm;

    /******
     * 执法人员分配渠道代码
     */
    @TableField("ZFRYFPQDDM")
    private String zfryfpqddm;

    /******
     * 岗位代码
     */
    @TableField("GWDM")
    private String gwdm;

    /******
     * 姓名
     */
    @TableField("XM")
    private String xm;

    /******
     * 出生日期
     */
    @TableField(value = "CSRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date csrq;

    /*****
     * 身份证件号码
     */
    @TableField("SFZJHM")
    private String sfzjhm;

    /*****
     * 照片地址
     */
    @TableField("ZPDZ")
    private String zpdz;

    /*****
     * 入党时间
     */
    @TableField("RDSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date rdsj;

    /*****
     * 毕业学校
     */
    @TableField("BYXX")
    private String byxx;

    /*****
     * 毕业专业
     */
    @TableField("BYZY")
    private String byzy;

    /*****
     * 毕业证书号
     */
    @TableField("BYZSH")
    private String byzsh;

    /*****
     * 毕业日期
     */
    @TableField("BYRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date byrq;

    /*****
     * 参加工作时间
     */
    @TableField("CJGZSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date cjgzsj;

    /******
     * 通讯地址
     */
    @TableField("TXDZ")
    private String txdz;

    /******
     * 邮政编码
     */
    @TableField("YZBM")
    private String yzbm;

    /******
     * 联系电话
     */
    @TableField("LXDH")
    private String lxdh;

    /******
     * 从事执法日期
     */
    @TableField("CSZFRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date cszfrq;

    /******
     * 入职时间
     */
    @TableField("RZSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date rzsj;

    /******
     * 现有省内执法证号
     */
    @TableField("XYSNZFZH")
    private String xysnzfzh;

    /******
     * 现有部级执法证号
     */
    @TableField("XYBJZFZH")
    private String xybjzfzh;

    /******
     * 执法证号
     */
    @TableField("ZFZH")
    private String zfzh;

    /******
     * 岗位培训证书编号
     */
    @TableField("GWPXZSBH")
    private String gwpxzsbh;

    /******
     * 执法区域
     */
    @TableField("ZFQY")
    private String zfqy;

    /******
     * 资料附件
     */
    @TableField("ZLFJ")
    private String zlfj;

    /******
     * 备注
     */
    @TableField("BZ")
    private String bz;

    /******
     * 是否具有法律职业资格
     */
    @TableField("SFJYFLZYZG")
    private String sfjyflzyzg;

    /******
     * 是否监督人员
     */
    @TableField("SFJDRY")
    private String sfjdry;

    /******
     * 资格证书编号
     */
    @TableField("ZGZSBH")
    private String zgzsbh;

    /******
     * 专业分类代码
     */
    @TableField("ZYFLDM")
    private String zyfldm;

    /******
     * 学历代码大类
     */
    @TableField("XLDMDL")
    private String xldmdl;

    /******
     * 是否更新
     */
    @TableField("SFGX")
    private String sfgx;

    /******
     * 岗位等级代码的value
     */
    @TableField("GWDJDM_VALUE")
    private String gwdjdmValue;

    /*****
     * 执法人员年龄
     */
    @TableField(exist = false)
    private String zfryAge;

    /*****
     * 组织机构Id
     */
    @TableField(exist = false)
    private String sysOrgId;

    /*****
     * 行政区划Id
     */
    @TableField(exist = false)
    private String xzqhId;

    /*****
     * 学历代码Text
     */
    @TableField(exist = false)
    private String xldmText;

    /*****
     * 政治面貌代码Text
     */
    @TableField(exist = false)
    private String zzmmdmText;

    /*****
     * 组织机构名称
     */
    @TableField(exist = false)
    private String zzjgName;

    /*****
     * 职务代码Text
     */
    @TableField(exist = false)
    private String zwdmText;

    /*****
     * 执法门类代码Text
     */
    @TableField(exist = false)
    private String zfmldmText;

    /*****
     * 人员编制代码Text
     */
    @TableField(exist = false)
    private String rybzdmText;

    /*****
     * 职务级别代码Text
     */
    @TableField(exist = false)
    private String zwjbdmText;

    /*****
     * 任职状态代码Text
     */
    @TableField(exist = false)
    private String rzztdmText;

    /*****
     * 执法人员类型代码Text
     */
    @TableField(exist = false)
    private String zfrylxdmText;

    /*****
     * 民族代码Text
     */
    @TableField(exist = false)
    private String mzdmText;

    /*****
     * 执法人员性质代码Text
     */
    @TableField(exist = false)
    private String zfryxzdmText;

    /*****
     * 人员审批状态代码Text
     */
    @TableField(exist = false)
    private String ryspztdmText;

    /*****
     * 证件状态代码Text
     */
    @TableField(exist = false)
    private String zjztdmText;

    /*****
     * 性别代码Text
     */
    @TableField(exist = false)
    private String xbdmText;

    /*****
     * 执法人员分配渠道代码Text
     */
    @TableField(exist = false)
    private String zfryfpqddmText;

    /*****
     * 岗位代码Text
     */
    @TableField(exist = false)
    private String gwdmText;

    /*****
     * 是否具有法律职业资格Text
     */
    @TableField(exist = false)
    private String sfjyflzyzgText;

    /*****
     * 是否监督人员Text
     */
    @TableField(exist = false)
    private String sfjdryText;

    /*****
     * 专业分类代码Text
     */
    @TableField(exist = false)
    private String zyfldmText;

    /*****
     * 学历代码大类Text
     */
    @TableField(exist = false)
    private String xldmdlText;

    /*****
     * 是否更新Text
     */
    @TableField(exist = false)
    private String sfgxText;

    /*****
     * 档案文件附件(前台往后台传)
     */
    @TableField(exist = false)
    private String archivesAttachDetails;

    /**
     * 档案文件附件List信息(后台往前台传)
     */
    @TableField(exist = false)
    public List<AttachmentVo> archivesAttachList = new ArrayList<>();

    /*****
     * 照片文件附件(前台往后台传)
     */
    @TableField(exist = false)
    private String photoAttachDetails;

    /**
     * 照片文件附件List信息(后台往前台传)
     */
    @TableField(exist = false)
    public List<AttachmentVo> photoAttachList = new ArrayList<>();

    @Override
    public String getId() {
        return zfryxxId;
    }

    @Override
    public void setId(String id) {
        this.zfryxxId = id;
    }
}
