package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfryRyspbVo
 * @author chris
 * @description 执法人员人员审批表实体类
 * @version 1.0
 * @date 2021-03-30 19:14
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_RYSPB")
public class ZfryRyspbVo extends BaseEntity<String> {

    /******
     * 人员审批表信息Id
     */
    @TableId
    @TableField("RYSPB_ID")
    private String ryspbId;

    /******
     * 审批类型代码
     */
    @TableField("SPLXDM")
    private String splxdm;

    /******
     * 审批状态代码
     */
    @TableField("SPZTDM")
    private String spztdm;

    /******
     * 待审核机构Id
     */
    @TableField("ZZJGID_DSHJG")
    private String zzjgidDshjg;

    /******
     * 填报日期
     */
    @TableField("TBRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date tbrq;

    /******
     * 填报人Id
     */
    @TableField("TBR_ID")
    private String tbrId;

    /******
     * 填报人名称
     */
    @TableField("TBR")
    private String tbr;

    /******
     * 填报单位
     */
    @TableField("TBDW_ID")
    private String tbdwId;

    /******
     * 填报单位名称
     */
    @TableField("TBDW")
    private String tbdw;

    /******
     * 所有审批机构Id
     */
    @TableField("SYSPJG")
    private String syspjg;

    /******
     * 申请人数
     */
    @TableField("SQRS")
    private String sqrs;

    /******
     * 通过人数
     */
    @TableField("TGRS")
    private String tgrs;

    /******
     * 县级组织机构Id
     */
    @TableField("ZZJGID_XJ")
    private String zzjgidXj;

    /******
     * 县级审批意见
     */
    @TableField("XJSPYJ")
    private String xjspyj;

    /******
     * 县级审批人Id
     */
    @TableField("XJSPR_ID")
    private String xjsprId;

    /******
     * 县级审批人名称
     */
    @TableField("XJSPR")
    private String xjspr;

    /******
     * 县级负责人名称
     */
    @TableField("XJFZR")
    private String xjfzr;

    /******
     * 县级审批日期
     */
    @TableField("XJSPRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date xjsprq;

    /******
     * 市级组织机构Id
     */
    @TableField("ZZJGID_SJ")
    private String zzjgidSj;

    /******
     * 市级审批意见
     */
    @TableField("SJSPYJ")
    private String sjspyj;

    /******
     * 市级审批人Id
     */
    @TableField("SJSPR_ID")
    private String sjsprId;

    /******
     * 市级审批人
     */
    @TableField("SJSPR")
    private String sjspr;

    /******
     * 市级负责人
     */
    @TableField("SJFZR")
    private String sjfzr;

    /******
     * 市级审批日期
     */
    @TableField("SJSPRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date sjsprq;

    /******
     * 发证组织机构Id
     */
    @TableField("ZZJGID_FZJG")
    private String zzjgidFzjg;

    /******
     * 发证机构审批意见
     */
    @TableField("FZJGSPYJ")
    private String fzjgspyj;

    /******
     * 发证机构审批人Id
     */
    @TableField("FZJGSPR_ID")
    private String fzjgsprId;

    /******
     * 发证机构审批人
     */
    @TableField("FZJGSPR")
    private String fzjgspr;

    /******
     * 发证机构负责人
     */
    @TableField("FZJGFZR")
    private String fzjgfzr;

    /******
     * 发证机构审批日期
     */
    @TableField("FZJGSPRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATETIME_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date fzjgsprq;

    /******
     * 锁定状态
     */
    @TableField("SDZT")
    private String sdzt;

    /******
     * 锁定人Id
     */
    @TableField("SDR_ID")
    private String sdrId;

    /******
     * 锁定人名称
     */
    @TableField("SDRXM")
    private String sdrxm;

    /*****
     * 审批类型代码Text
     */
    @TableField(exist = false)
    private String splxdmText;

    /*****
     * 审批状态代码Text
     */
    @TableField(exist = false)
    private String spztdmText;

    /*****
     * 锁定状态代码Text
     */
    @TableField(exist = false)
    private String sdztText;

    /*****
     * 待审核组织机构名称
     */
    @TableField(exist = false)
    private String dshjgZzjgName;

    /*****
     * 县级组织机构名称
     */
    @TableField(exist = false)
    private String xjZzjgName;

    /*****
     * 市级组织机构名称
     */
    @TableField(exist = false)
    private String sjZzjgName;

    /*****
     * 发证组织机构名称
     */
    @TableField(exist = false)
    private String fzjgZzjgName;

    @Override
    public String getId() {
        return ryspbId;
    }

    @Override
    public void setId(String id) {
        this.ryspbId = id;
    }
}
