package com.kdgcsoft.jt.xzzf.dubbo.zfry.zfry.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfryRypxxxVo
 * @author chris
 * @description 执法人员的培训信息实体类
 * @version 1.0
 * @date 2021-03-30 19:11
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFRY + "ZFRYGL_J_RYPXXX")
public class ZfryRypxxxVo extends BaseEntity<String> {
    /******
     * 人员培训信息Id
     */
    @TableId
    @TableField("RYPXXX_ID")
    private String rypxxxId;

    /******
     * 执法人员信息Id
     */
    @TableField("ZFRYXX_ID")
    private String zfryxxId;

    /******
     * 培训类型代码
     */
    @TableField("PXLXDM")
    private String pxlxdm;

    /******
     * 附加信息来源代码
     */
    @TableField("FJXXSJLYDM")
    private String fjxxsjlydm;

    /******
     * 培训开始日期
     */
    @TableField("PXKSRQ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date pxksrq;

    /******
     * 培训结束日期
     */
    @TableField("PXJSSJ")
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date pxjssj;

    /******
     * 证书编号
     */
    @TableField("ZSBH")
    private String zsbh;

    /******
     * 证书名称
     */
    @TableField("ZSMC")
    private String zsmc;

    /******
     * 培训机构名称
     */
    @TableField("PXJGMC")
    private String pxjgmc;

    /******
     * 培训结果:0-不合格,1-合格
     */
    @TableField("PXJG")
    private String pxjg;

    /******
     * 所获学分
     */
    @TableField("SHXF")
    private String shxf;

    /******
     * 备注
     */
    @TableField("BZ")
    private String bz;

    /******
     * 培训类型代码Text
     */
    @TableField(exist = false)
    private String pxlxdmText;

    /*****
     * 附加信息来源代码Text
     */
    @TableField(exist = false)
    private String fjxxsjlydmText;

    /*****
     * 培训结果Text
     */
    @TableField(exist = false)
    private String pxjgText;

    @Override
    public String getId() {
        return rypxxxId;
    }

    @Override
    public void setId(String id) {
        this.rypxxxId = id;
    }
}
